#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics/Signals/FractionOutputTrait.h>
/* Generated code for model FractionOutput */
namespace openplx::Physics::Signals {
    /**
     * A Output that is a fraction.
     * Preferrably between zero and one, but not forced to be.
     **/
    class FractionOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics::Signals::FractionOutputTrait> m_source;

        public:
            FractionOutput();
            std::shared_ptr<openplx::Physics::Signals::FractionOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
