#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Charges/Material.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>
/* Generated code for model LinearElasticMaterial */
namespace openplx::Physics::Charges {
    /**
     *     Defines an isotropic elastic material.
     *     The youngs_modulus, also known as the elastic modulus, is required to define the elasticity.
     *     */
    class LinearElasticMaterial : public openplx::Physics::Charges::Material {
        protected:
            double m_youngs_modulus;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;

        public:
            LinearElasticMaterial();
            double youngs_modulus() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
