
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/AnalysisContext.h>

namespace openplx
{
    /**
     * Implements pass 2 of semantic analysis as outlined in developer/BrickSemanticAnalysis.md
     */
    class Pass2Visitor : public NodeVisitor
    {
        public:

            Pass2Visitor(Analysis::AnalysisContext* context) : m_context(context) {}

            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitOperatorOverload(const OpOverloadPtr &op_overload) override;

        private:

            void reportError(error_code_t error_code, line_t line, col_t column);
            void reportError(error_code_t error_code, const Token& first_token, const Token& last_token);
            void reportError(error_code_t error_code, const Token& token);
            void reportError(error_code_t error_code, const std::vector<Token>& segments);

            Analysis::AnalysisContext* m_context;
            DocPtr m_document;
            ModelDeclPtr m_model;
    };
}
