#pragma once

#include <memory>
#include <stdint.h>
#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>
#include <openplx/AnalysisContext.h>

namespace openplx {

    /**
       Reports errors on colliding symbols that are not in the same file/model.
     */
    class InvalidateGlobalDuplicateSymbolsVisitor : private NodeVisitor {
        public:
            explicit InvalidateGlobalDuplicateSymbolsVisitor(
                std::shared_ptr<ErrorReporter> error_reporter);
            void validate(const DocPtr& document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitMethodDeclaration(const MethodDeclPtr& method_declaration) override;
            void visitTraitImpl(const TraitImplPtr& trait_impl) override;

            std::shared_ptr<ErrorReporter> m_error_reporter;
    };
}
