
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class Initializer : public Expression, public std::enable_shared_from_this<Initializer>
    {
        public:
            /* Factories */
            static InitializerPtr create(const std::vector<ExprPtr>& elements, const Token& left_brace, const Token& right_brace);

            /* Overrides */
            InitializerPtr asInitializer() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Members */
            const std::vector<ExprPtr>& getElements() const;
            void appendToElements(ExprPtr member);

        private:
            Initializer();
            std::vector<ExprPtr> m_elements;
    };
}
