#pragma once
#include <string>

namespace openplx
{
class Error;
class CycleFoundError;
class StringParameterError;

/**
 * Using an ErrorVisitor enables us to
 *  - implement specific error messages for each error type
 *  - fail with warning message and output log message in case a developer used an incorrect Class for an error Enum
 *  - add new error types without modifying the Error class
 */
class ErrorVisitor
{
    public:
        virtual std::string visitError(const Error& error) = 0;
        virtual std::string visitCycleFoundError(const CycleFoundError& error) = 0;
        virtual std::string visitStringParameterError(const StringParameterError& error) = 0;
        virtual ~ErrorVisitor() = default;
};

}
