#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DInputTrait.h>
#include <openplx/Physics/Signals/Torque1DInput.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
/* Generated code for model TorqueMotor */
namespace openplx::DriveTrain {
    class TorqueMotor : public openplx::Physics::Interactions::Interaction1DOF, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::Torque1DInputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Torque1DInput> m_torque_input;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;

        public:
            TorqueMotor();
            std::shared_ptr<openplx::Physics::Signals::Torque1DInput> torque_input() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
