/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/export.h>

#include <agx/Matrix3x3.h>

namespace agxSensor
{
  /**
  Specification of cross sensitivity between tree axis.
  */
  class AGXSENSOR_EXPORT TriaxialCrossSensitivity
  {
    public:
      /**
      Constructs a triaxial cross sensitivity based by applying the common \p crossSensitivity to
      the interactions between each axis.
      \param crossSensitivity - common cross sensitivity value for all axis
      */
      TriaxialCrossSensitivity( agx::Real crossSensitivity = 0.01 );

      /**
      Constructs a triaxial cross sensitivity directly with the given matrix.
      \param crossSensitivity - matrix describing the cross sensitivity interaction, each row should
                                be of unit length
      */
      TriaxialCrossSensitivity( agx::Matrix3x3 crossSensitivity );

      /**
      \return the cross sensitivity interaction matrix
      */
      agx::Matrix3x3 getCrossAxisMatrix() const;

    private:
      agx::Matrix3x3 m_crossAxisMatrix;
  };
}
