/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <string>
#include <agxOpenPLX/export.h>
#include <openplx/Error.h>
#include <openplx/ErrorFormatter.h>

namespace agxopenplx {
    class AgxOpenPlxErrorFormatter : public openplx::ErrorFormatter {
        public:
            virtual std::string visitError(const openplx::Error& error) override;
            virtual std::string visitStringParameterError(const openplx::StringParameterError& error) override;
    };

    /**
     * Workaround for testing to avoid having to export the AgxOpenPlxErrorFormatter which is only used internally
     */
    class AgxOpenPlxErrorFormatterWrapper {
        public:
            AGXOPENPLX_EXPORT AgxOpenPlxErrorFormatterWrapper();
            AGXOPENPLX_EXPORT std::string format(openplx::Error& error);
        private:
            std::unique_ptr<AgxOpenPlxErrorFormatter> m_wrapped;
    };
}
