/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <openplx/Error.h>

namespace openplx::agxerror {
    constexpr openplx::error_code_t ModelWasNotSimulatable = 1;
    constexpr openplx::error_code_t MissingConnectedBody = 2;
    constexpr openplx::error_code_t AgxIsNotInitialized = 3;
    constexpr openplx::error_code_t InvalidMateConnectorAxis = 4;
    constexpr openplx::error_code_t PathNotAbsolute = 5;
    constexpr openplx::error_code_t InvalidObjFile = 6;
    constexpr openplx::error_code_t InvalidFrictionModel = 7;
    constexpr openplx::error_code_t DuplicateAnnotation = 8;
    constexpr openplx::error_code_t MissingConnectedGeometry = 9;
    constexpr openplx::error_code_t InvalidTriMesh = 10;
    constexpr openplx::error_code_t MissingGeometryMassTensor = 11;
    constexpr openplx::error_code_t NegativeMass = 12;
    constexpr openplx::error_code_t InvalidInertiaTensor = 13;
    constexpr openplx::error_code_t DuplicateMaterialPairForSurfaceContactModelDefinition = 14;
    constexpr openplx::error_code_t MisplacedMateConnector = 15;
    constexpr openplx::error_code_t MissingTrait = 16;
    constexpr openplx::error_code_t MisplacedBody = 17;
    constexpr openplx::error_code_t MissingTerrainMaterialConfiguration = 18;
    constexpr openplx::error_code_t MaterialsMustBeUnique = 19;
}
