/*
Copyright 2007-2023. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or
having been advised so by Algoryx Simulation AB for a time limited evaluation,
or having purchased a valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/


/////////////////////////////////////////////////////////////////////
// AUTOMATICALLY GENERATED, DO NOT EDIT! (except inline functions) //
/////////////////////////////////////////////////////////////////////

#ifndef AGXFN_PHYSICS_PARTICLESYSTEM_GAUSSSEIDELCONTACTSOLVER_CALCULATEJACOBIANS_H
#define AGXFN_PHYSICS_PARTICLESYSTEM_GAUSSSEIDELCONTACTSOLVER_CALCULATEJACOBIANS_H

#include <agxData/Array.h>
#include <agxData/EntityPtr.h>
#include <agx/Integer.h>
#include <agx/Real.h>
#include <agx/Math.h>
#include <agx/Job.h>
#include <agx/Physics/Particle/ContactConstraintEntity.h>
#include <agx/Physics/GraphNodeEntity.h>
#include <agx/Jacobian.h>
#include <agx/Physics/Particle/ContactConstraintRowEntity.h>
#include <agx/Physics/ParticlePairContactEntity.h>
#include <agx/Physics/ContactMaterialEntity.h>
#include <agx/Vec3.h>
#include <agx/Physics/ParticleEntity.h>
#include <agx/ParticleState.h>
#include <agx/Physics/MaterialEntity.h>
#include <agx/Physics/CollisionGroupSetEntity.h>
#include <agx/Uuid.h>
#include <agx/Vec4.h>
#include <agx/Physics/Particle/ParticleBodyContactConstraintEntity.h>
#include <agx/Physics/ParticleGeometryContactEntity.h>
#include <agx/Physics/GeometryEntity.h>
#include <agx/Physics/RigidBodyEntity.h>
#include <agx/SpinMutex.h>
#include <agx/RigidBodyState.h>
#include <agx/Name.h>
#include <agx/SPDMatrix3x3.h>
#include <agx/Matrix3x3.h>
#include <agx/AffineMatrix4x4.h>
#include <agx/Range6.h>


namespace agx { namespace Physics { namespace ParticleSystem { namespace GaussSeidelContactSolver { } } } }

namespace agxFn
{
  namespace Physics
  {
    namespace ParticleSystem
    {
      namespace GaussSeidelContactSolver
      {
        /**
        Function: Physics.ParticleSystem.GaussSeidelContactSolver.CalculateJacobians
        Implementation: ParticlePairContact

        \param job The range job specifying what part of the data set to process
        \param constraint 
        \param constraintRow 
        \param contact 
        \param particle 
        \param timeStep 
        \param impactCondition 
        */
        void CalculateJacobians__ParticlePairContact
        (
          /* Parameter list automatically generated, do not edit */
          const agx::RangeJob& job,
          agx::Physics::Particle::ContactConstraintData& constraint,
          agx::Physics::Particle::ContactConstraintRowData& constraintRow,
          agx::Physics::ParticlePairContactData& contact,
          agx::Physics::ParticleData& particle,
          const agx::Real& timeStep,
          const agx::Real& impactCondition
        );


        /**
        Function: Physics.ParticleSystem.GaussSeidelContactSolver.CalculateJacobians
        Implementation: ParticleGeometryContact

        \param job The range job specifying what part of the data set to process
        \param constraint 
        \param constraintRow 
        \param contact 
        \param particle 
        \param rigidBody 
        \param timeStep 
        \param impactCondition 
        */
        void CalculateJacobians__ParticleGeometryContact
        (
          /* Parameter list automatically generated, do not edit */
          const agx::RangeJob& job,
          agx::Physics::Particle::ParticleBodyContactConstraintData& constraint,
          agx::Physics::Particle::ContactConstraintRowData& constraintRow,
          agx::Physics::ParticleGeometryContactData& contact,
          agx::Physics::ParticleData& particle,
          agx::Physics::RigidBodyData& rigidBody,
          const agx::Real& timeStep,
          const agx::Real& impactCondition
        );


      }
    }
  }
}

#endif
