// Copyright 2023, Algoryx Simulation AB.

#pragma once

#include "CoreMinimal.h"
#include "Stats/Stats.h"

// clang-format off

// Statistics generated by the plugin itself.
// These are enabled with 'stat AGXUnreal' in the console
DECLARE_STATS_GROUP(TEXT("AGX Unreal"), STATGROUP_AGXUnreal, STATCAT_Advanced);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Step Time"), STAT_AGXU_StepTime, STATGROUP_AGXUnreal);
DECLARE_DWORD_COUNTER_STAT(TEXT("Num. Steps"), STAT_AGXU_NumSteps, STATGROUP_AGXUnreal);

// Timers read from AGX Dynamics, last step in a frame only. So timer spikes in non-last frames will
// not be visible. Use the FRAME stats to detect those.
// These are enabled with 'stat AGXDynamicsStepTimers' in the console
DECLARE_STATS_GROUP(TEXT("AGX Dynamics Timers Last Step Forward"), STATGROUP_AGXDynamicsStepTimers, STATCAT_Advanced);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Step Forward Time"), STAT_AGXD_StepForward_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Space Update Time"), STAT_AGXD_SpaceUpdate_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Dynamics Update Time"), STAT_AGXD_DynamicsUpdate_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Pre-collide Time"), STAT_AGXD_PreCollide_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Contact Events Time"), STAT_AGXD_ContactEvents_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Pre-step Time"), STAT_AGXD_PreStep_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Post-step Time"), STAT_AGXD_PostStep_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Last-step Time"), STAT_AGXD_LastStep_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Inter-step Time"), STAT_AGXD_InterStep_STEP, STATGROUP_AGXDynamicsStepTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("The rest"), STAT_AGXD_Unaccounted_STEP, STATGROUP_AGXDynamicsStepTimers);

// Timers read from AGX Dynamics accumulated over a frame.
// These are enabled with 'stat AGXDynamicsFrameTimers' in the console
DECLARE_STATS_GROUP(TEXT("AGX Dynamics Timers Entire Frame"), STATGROUP_AGXDynamicsFrameTimers, STATCAT_Advanced);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Step Forward Time"), STAT_AGXD_StepForward_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Space Update Time"), STAT_AGXD_SpaceUpdate_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Dynamics Update Time"), STAT_AGXD_DynamicsUpdate_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Pre-collide Time"), STAT_AGXD_PreCollide_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Contact Events Time"), STAT_AGXD_ContactEvents_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Pre-step Time"), STAT_AGXD_PreStep_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Post-step Time"), STAT_AGXD_PostStep_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Last-step Time"), STAT_AGXD_LastStep_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("Inter-step Time"), STAT_AGXD_InterStep_FRAME, STATGROUP_AGXDynamicsFrameTimers);
DECLARE_FLOAT_COUNTER_STAT(TEXT("The rest"), STAT_AGXD_Unaccounted_FRAME, STATGROUP_AGXDynamicsFrameTimers);

// Counters read from AGX Dynamics. These are only reported for the last Step Forward in a frame,
// so if the numbers vary during that frame then only the last frame's number will be reported.
// These are enabled with 'stat AGXDynamicsCounts' in the console
DECLARE_STATS_GROUP(TEXT("AGX Dynamics Counts"), STATGROUP_AGXDynamicsCounts, STATCAT_Advanced);
DECLARE_DWORD_COUNTER_STAT(TEXT("Num. Bodies"), STAT_AGXD_NumBodies, STATGROUP_AGXDynamicsCounts);
DECLARE_DWORD_COUNTER_STAT(TEXT("Num. Constraints"), STAT_AGXD_NumConstraints, STATGROUP_AGXDynamicsCounts);
DECLARE_DWORD_COUNTER_STAT(TEXT("Num. Contact Constraints"), STAT_AGXD_NumContactConstraints, STATGROUP_AGXDynamicsCounts);
DECLARE_DWORD_COUNTER_STAT(TEXT("Num. Particles"), STAT_AGXD_NumParticles, STATGROUP_AGXDynamicsCounts);

// clang-format on
