%module(package="openplx") Visuals
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Visuals/Visuals_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Visuals/Visuals.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Visuals(Visuals_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Visuals();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Visuals();
OPENPLX_SWIG_BUNDLE_VECTORS_Visuals();
%include "openplx/Visuals/Materials/Material.h"
%include "openplx/Visuals/Materials/TextureMaterial.h"
%include "openplx/Visuals/Geometries/Geometry.h"
%include "openplx/Visuals/Geometries/Box.h"
%include "openplx/Visuals/Geometries/Cylinder.h"
%include "openplx/Visuals/Geometries/TriMeshGeometry.h"
%include "openplx/Visuals/Geometries/Sphere.h"
%include "openplx/Visuals/Geometries/ConvexMesh.h"
%include "openplx/Visuals/Geometries/ExternalTriMeshGeometry.h"
