%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles(prefix)
%rename(prefix ## Base) openplx::Vehicles::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles()
%shared_ptr(openplx::Vehicles::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles()
%typemap(out) std::shared_ptr<openplx::Vehicles::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles()
%template(Vehicles_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles()
%include "openplx/Vehicles/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles()
%pythoncode %{
from . import Chassis
from . import FourWheel
from . import Steering
from . import Suspensions
from . import Tracks
from . import Wheels
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated(prefix)
%rename(prefix ## Base) openplx::Vehicles::Chassis::Articulated::Base;
%rename(prefix ## Hinge) openplx::Vehicles::Chassis::Articulated::Hinge;
%rename(prefix ## SingleJoint) openplx::Vehicles::Chassis::Articulated::SingleJoint;
%rename(prefix ## Universal) openplx::Vehicles::Chassis::Articulated::Universal;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated()
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Hinge);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::SingleJoint);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Universal);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated()
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated()
%template(Vehicles_Chassis_Articulated_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Chassis_Articulated_Hinge_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Chassis_Articulated_SingleJoint_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::SingleJoint>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Chassis_Articulated_Universal_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Universal>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated()
%include "openplx/Vehicles/Chassis/Articulated/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/SingleJoint.h"
%include "openplx/Vehicles/Chassis/Articulated/Hinge.h"
%include "openplx/Vehicles/Chassis/Articulated/Universal.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated()
%pythoncode %{
from . import Connections
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Composite()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Composite()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Composite(prefix)
%rename(prefix ## Base) openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base;
%rename(prefix ## OneLink) openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Composite()
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base);
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Composite()
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Composite()
%template(Vehicles_Chassis_Articulated_Connections_Composite_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Chassis_Articulated_Connections_Composite_OneLink_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Composite::OneLink>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Composite()
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/Base.h"
%include "openplx/Vehicles/Chassis/Articulated/Connections/Composite/OneLink.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated_Connections_Composite()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated_Connections_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Single()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated_Connections_Single()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Single(prefix)
%rename(prefix ## Base) openplx::Vehicles::Chassis::Articulated::Connections::Single::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Single()
%shared_ptr(openplx::Vehicles::Chassis::Articulated::Connections::Single::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Single()
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Single()
%template(Vehicles_Chassis_Articulated_Connections_Single_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Articulated::Connections::Single::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Single()
%include "openplx/Vehicles/Chassis/Articulated/Connections/Single/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated_Connections_Single()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Articulated_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Articulated_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Articulated_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Chassis_Rigid()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Chassis_Rigid()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Rigid(prefix)
%rename(prefix ## Base) openplx::Vehicles::Chassis::Rigid::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Rigid()
%shared_ptr(openplx::Vehicles::Chassis::Rigid::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Rigid()
%typemap(out) std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Rigid()
%template(Vehicles_Chassis_Rigid_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Chassis::Rigid::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Rigid()
%include "openplx/Vehicles/Chassis/Rigid/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Chassis_Rigid()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_FourWheel()
%import "Vehicles.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_FourWheel()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel(prefix)
%rename(prefix ## Base) openplx::Vehicles::FourWheel::Base;
%rename(prefix ## FrontWheelDrive) openplx::Vehicles::FourWheel::FrontWheelDrive;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel()
%shared_ptr(openplx::Vehicles::FourWheel::Base);
%shared_ptr(openplx::Vehicles::FourWheel::FrontWheelDrive);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel()
%typemap(out) std::shared_ptr<openplx::Vehicles::FourWheel::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel()
%template(Vehicles_FourWheel_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_FourWheel_FrontWheelDrive_Vector) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::FourWheel::FrontWheelDrive>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel()
%include "openplx/Vehicles/FourWheel/Base.h"
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_FourWheel()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_FourWheel_Properties()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_FourWheel_Properties()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel_Properties(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel_Properties()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel_Properties()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel_Properties()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel_Properties()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_FourWheel_Properties()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering(prefix)
%rename(prefix ## Base) openplx::Vehicles::Steering::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering()
%shared_ptr(openplx::Vehicles::Steering::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering()
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering()
%template(Vehicles_Steering_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering()
%include "openplx/Vehicles/Steering/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering()
%pythoncode %{
from . import Articulated
from . import Kinematic
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering_Articulated()
%import "Vehicles_Steering.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering_Articulated()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Articulated(prefix)
%rename(prefix ## Base) openplx::Vehicles::Steering::Articulated::Base;
%rename(prefix ## DualActuator) openplx::Vehicles::Steering::Articulated::DualActuator;
%rename(prefix ## DualCylinder) openplx::Vehicles::Steering::Articulated::DualCylinder;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Articulated()
%shared_ptr(openplx::Vehicles::Steering::Articulated::Base);
%shared_ptr(openplx::Vehicles::Steering::Articulated::DualActuator);
%shared_ptr(openplx::Vehicles::Steering::Articulated::DualCylinder);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Articulated()
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Articulated()
%template(Vehicles_Steering_Articulated_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Articulated_DualActuator_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualActuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Articulated_DualCylinder_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Articulated::DualCylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Articulated()
%include "openplx/Vehicles/Steering/Articulated/Base.h"
%include "openplx/Vehicles/Steering/Articulated/DualActuator.h"
%include "openplx/Vehicles/Steering/Articulated/DualCylinder.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering_Articulated()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering_Kinematic()
%import "Vehicles_Steering.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering_Kinematic()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Kinematic(prefix)
%rename(prefix ## Ackermann) openplx::Vehicles::Steering::Kinematic::Ackermann;
%rename(prefix ## Base) openplx::Vehicles::Steering::Kinematic::Base;
%rename(prefix ## BellCrank) openplx::Vehicles::Steering::Kinematic::BellCrank;
%rename(prefix ## RackAndPinion) openplx::Vehicles::Steering::Kinematic::RackAndPinion;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Kinematic()
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Base);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::RackAndPinion);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Kinematic()
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Kinematic()
%template(Vehicles_Steering_Kinematic_Ackermann_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_BellCrank_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_RackAndPinion_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Kinematic()
%include "openplx/Vehicles/Steering/Kinematic/Base.h"
%include "openplx/Vehicles/Steering/Kinematic/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/RackAndPinion.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering_Kinematic()
%pythoncode %{
from . import Interactions
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Steering_Kinematic_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Steering_Kinematic_Interactions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Kinematic_Interactions(prefix)
%rename(prefix ## Ackermann) openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann;
%rename(prefix ## Base) openplx::Vehicles::Steering::Kinematic::Interactions::Base;
%rename(prefix ## BellCrank) openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank;
%rename(prefix ## RackAndPinion) openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Kinematic_Interactions()
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::Base);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank);
%shared_ptr(openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Kinematic_Interactions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Kinematic_Interactions()
%template(Vehicles_Steering_Kinematic_Interactions_Ackermann_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Ackermann>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_Interactions_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_Interactions_BellCrank_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::BellCrank>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Steering_Kinematic_Interactions_RackAndPinion_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Steering::Kinematic::Interactions::RackAndPinion>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Kinematic_Interactions()
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Base.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Kinematic/Interactions/RackAndPinion.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Steering_Kinematic_Interactions()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions(prefix)
%rename(prefix ## Base) openplx::Vehicles::Suspensions::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions()
%shared_ptr(openplx::Vehicles::Suspensions::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions()
%template(Vehicles_Suspensions_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions()
%include "openplx/Vehicles/Suspensions/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions()
%pythoncode %{
from . import SingleMate
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_Properties()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_Properties()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Properties(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Properties()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Properties()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Properties()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Properties()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_Properties()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_SingleMate()
%import "Vehicles_Suspensions.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_SingleMate()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate(prefix)
%rename(prefix ## Base) openplx::Vehicles::Suspensions::SingleMate::Base;
%rename(prefix ## LinearSpringDamper) openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate()
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Base);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate()
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate()
%template(Vehicles_Suspensions_SingleMate_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_SingleMate_LinearSpringDamper_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate()
%include "openplx/Vehicles/Suspensions/SingleMate/Base.h"
%include "openplx/Vehicles/Suspensions/SingleMate/LinearSpringDamper.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_SingleMate()
%pythoncode %{
from . import Interactions
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_SingleMate_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_SingleMate_Interactions()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate_Interactions(prefix)
%rename(prefix ## Base) openplx::Vehicles::Suspensions::SingleMate::Interactions::Base;
%rename(prefix ## LinearSpringDamper) openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate_Interactions()
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Interactions::Base);
%shared_ptr(openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate_Interactions()
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate_Interactions()
%template(Vehicles_Suspensions_SingleMate_Interactions_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Suspensions_SingleMate_Interactions_LinearSpringDamper_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Suspensions::SingleMate::Interactions::LinearSpringDamper>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate_Interactions()
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/Base.h"
%include "openplx/Vehicles/Suspensions/SingleMate/Interactions/LinearSpringDamper.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_SingleMate_Interactions()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Suspensions_SingleMate_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Suspensions_SingleMate_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Suspensions_SingleMate_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Tracks()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Tracks()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix)
%rename(prefix ## Belt) openplx::Vehicles::Tracks::Belt;
%rename(prefix ## BoxLinkDescription) openplx::Vehicles::Tracks::BoxLinkDescription;
%rename(prefix ## BoxLinkVariation) openplx::Vehicles::Tracks::BoxLinkVariation;
%rename(prefix ## ContactGeometryLinkDescription) openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%rename(prefix ## CyclicVariation) openplx::Vehicles::Tracks::CyclicVariation;
%rename(prefix ## CylindricalIdler) openplx::Vehicles::Tracks::CylindricalIdler;
%rename(prefix ## CylindricalRoadWheel) openplx::Vehicles::Tracks::CylindricalRoadWheel;
%rename(prefix ## CylindricalRoller) openplx::Vehicles::Tracks::CylindricalRoller;
%rename(prefix ## CylindricalSprocket) openplx::Vehicles::Tracks::CylindricalSprocket;
%rename(prefix ## DefaultLinkDescription) openplx::Vehicles::Tracks::DefaultLinkDescription;
%rename(prefix ## DefaultLinkVariation) openplx::Vehicles::Tracks::DefaultLinkVariation;
%rename(prefix ## DiscretePulseVariation) openplx::Vehicles::Tracks::DiscretePulseVariation;
%rename(prefix ## FixedLinkCountBelt) openplx::Vehicles::Tracks::FixedLinkCountBelt;
%rename(prefix ## IntertialRoadWheel) openplx::Vehicles::Tracks::IntertialRoadWheel;
%rename(prefix ## RigidCylindricalIdler) openplx::Vehicles::Tracks::RigidCylindricalIdler;
%rename(prefix ## RigidCylindricalRoadWheelBody) openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%rename(prefix ## RigidCylindricalRoller) openplx::Vehicles::Tracks::RigidCylindricalRoller;
%rename(prefix ## RigidCylindricalSprocket) openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%rename(prefix ## RoadWheel) openplx::Vehicles::Tracks::RoadWheel;
%rename(prefix ## SinusoidalVariation) openplx::Vehicles::Tracks::SinusoidalVariation;
%rename(prefix ## System) openplx::Vehicles::Tracks::System;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks()
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks()
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::Belt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::System> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks()
%template(Vehicles_Tracks_Belt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_ContactGeometryLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CyclicVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DiscretePulseVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_FixedLinkCountBelt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_IntertialRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoadWheelBody_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_SinusoidalVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_System_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks()
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Tracks()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels(prefix)
%rename(prefix ## Actuator) openplx::Vehicles::Wheels::Actuator;
%rename(prefix ## Base) openplx::Vehicles::Wheels::Base;
%rename(prefix ## ElasticWheel) openplx::Vehicles::Wheels::ElasticWheel;
%rename(prefix ## Rim) openplx::Vehicles::Wheels::Rim;
%rename(prefix ## Tire) openplx::Vehicles::Wheels::Tire;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels()
%shared_ptr(openplx::Vehicles::Wheels::Actuator);
%shared_ptr(openplx::Vehicles::Wheels::Base);
%shared_ptr(openplx::Vehicles::Wheels::ElasticWheel);
%shared_ptr(openplx::Vehicles::Wheels::Rim);
%shared_ptr(openplx::Vehicles::Wheels::Tire);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Actuator> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Rim> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Tire> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels()
%template(Vehicles_Wheels_Actuator_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Actuator>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Actuator>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Base_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_ElasticWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::ElasticWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Rim_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Rim>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Rim>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Rim>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Rim>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Rim>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Tire_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Tire>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Tire>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Tire>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Tire>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Tire>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels()
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Wheels/Base.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Wheels/Tire.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels()
%pythoncode %{
from . import Interactions
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels_Interactions_Dissipation()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels_Interactions_Dissipation()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Dissipation(prefix)
%rename(prefix ## DefaultWheelDissipation) openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation;
%rename(prefix ## WheelMechanicalDamping) openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Dissipation()
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Dissipation()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Dissipation()
%template(Vehicles_Wheels_Interactions_Dissipation_DefaultWheelDissipation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::DefaultWheelDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Interactions_Dissipation_WheelMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Dissipation::WheelMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Dissipation()
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels_Interactions_Dissipation()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Wheels_Interactions_Flexibility()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Wheels_Interactions_Flexibility()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Flexibility(prefix)
%rename(prefix ## DefaultWheelFlexibility) openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility;
%rename(prefix ## LinearElasticWheelFlexibility) openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Flexibility()
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility);
%shared_ptr(openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Flexibility()
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Flexibility()
%template(Vehicles_Wheels_Interactions_Flexibility_DefaultWheelFlexibility_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::DefaultWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Wheels_Interactions_Flexibility_LinearElasticWheelFlexibility_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Wheels::Interactions::Flexibility::LinearElasticWheelFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Flexibility()
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Wheels_Interactions_Flexibility()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Vehicles()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Vehicles()
%import "Vehicles.i"
%import "Vehicles_Chassis_Articulated.i"
%import "Vehicles_Chassis_Articulated_Connections_Composite.i"
%import "Vehicles_Chassis_Articulated_Connections_Composite_Interfaces.i"
%import "Vehicles_Chassis_Articulated_Connections_Interfaces.i"
%import "Vehicles_Chassis_Articulated_Connections_Single.i"
%import "Vehicles_Chassis_Articulated_Interfaces.i"
%import "Vehicles_Chassis_Rigid.i"
%import "Vehicles_FourWheel.i"
%import "Vehicles_FourWheel_Properties.i"
%import "Vehicles_Interfaces.i"
%import "Vehicles_Steering.i"
%import "Vehicles_Steering_Articulated.i"
%import "Vehicles_Steering_Interfaces.i"
%import "Vehicles_Steering_Kinematic.i"
%import "Vehicles_Steering_Kinematic_Interactions.i"
%import "Vehicles_Suspensions.i"
%import "Vehicles_Suspensions_Properties.i"
%import "Vehicles_Suspensions_SingleMate.i"
%import "Vehicles_Suspensions_SingleMate_Interactions.i"
%import "Vehicles_Suspensions_SingleMate_Interfaces.i"
%import "Vehicles_Tracks.i"
%import "Vehicles_Wheels.i"
%import "Vehicles_Wheels_Interactions_Dissipation.i"
%import "Vehicles_Wheels_Interactions_Flexibility.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Vehicles()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/MachineModeling/MachineModeling.i>
OPENPLX_SWIG_BUNDLE_IMPORT_MachineModeling();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%include <python/Simulation/Simulation.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Simulation();
%include <python/Visuals/Visuals.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Visuals();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Vehicles()
%import "DriveTrain.i"
%import "MachineModeling.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%import "Simulation.i"
%import "Visuals.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Vehicles(prefix)
OPENPLX_SWIG_NS_RENAMES_Vehicles(prefix);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated(prefix ## Chassis_Articulated_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Composite(prefix ## Chassis_Articulated_Connections_Composite_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces(prefix ## Chassis_Articulated_Connections_Composite_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Interfaces(prefix ## Chassis_Articulated_Connections_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Connections_Single(prefix ## Chassis_Articulated_Connections_Single_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Articulated_Interfaces(prefix ## Chassis_Articulated_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Chassis_Rigid(prefix ## Chassis_Rigid_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel(prefix ## FourWheel_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_FourWheel_Properties(prefix ## FourWheel_Properties_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Interfaces(prefix ## Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering(prefix ## Steering_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Articulated(prefix ## Steering_Articulated_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Interfaces(prefix ## Steering_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Kinematic(prefix ## Steering_Kinematic_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Steering_Kinematic_Interactions(prefix ## Steering_Kinematic_Interactions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions(prefix ## Suspensions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_Properties(prefix ## Suspensions_Properties_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate(prefix ## Suspensions_SingleMate_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate_Interactions(prefix ## Suspensions_SingleMate_Interactions_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Suspensions_SingleMate_Interfaces(prefix ## Suspensions_SingleMate_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix ## Tracks_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels(prefix ## Wheels_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Dissipation(prefix ## Wheels_Interactions_Dissipation_);
OPENPLX_SWIG_NS_RENAMES_Vehicles_Wheels_Interactions_Flexibility(prefix ## Wheels_Interactions_Flexibility_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Composite();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Connections_Single();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Articulated_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Chassis_Rigid();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_FourWheel_Properties();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Articulated();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Kinematic();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Steering_Kinematic_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_Properties();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Suspensions_SingleMate_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Composite();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Connections_Single();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Articulated_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Chassis_Rigid();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_FourWheel_Properties();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Articulated();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Kinematic();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Steering_Kinematic_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_Properties();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Suspensions_SingleMate_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Vehicles()
OPENPLX_SWIG_NS_VECTORS_Vehicles();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Composite();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Connections_Single();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Articulated_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Chassis_Rigid();
OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel();
OPENPLX_SWIG_NS_VECTORS_Vehicles_FourWheel_Properties();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Articulated();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Kinematic();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Steering_Kinematic_Interactions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_Properties();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate_Interactions();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Suspensions_SingleMate_Interfaces();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_VECTORS_Vehicles_Wheels_Interactions_Flexibility();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Vehicles()
OPENPLX_SWIG_NS_INCLUDES_Vehicles();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Composite();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Composite_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Connections_Single();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Articulated_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Chassis_Rigid();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_FourWheel_Properties();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Articulated();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Kinematic();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Steering_Kinematic_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_Properties();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Suspensions_SingleMate_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Dissipation();
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Wheels_Interactions_Flexibility();
%enddef

