%module(package="openplx") Terrain
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Terrain/Terrain_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Terrain/Terrain.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Terrain(Terrain_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Terrain();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Terrain();
OPENPLX_SWIG_BUNDLE_VECTORS_Terrain();
%include "openplx/Terrain/TerrainMaterial.h"
%include "openplx/Terrain/Shovel.h"
%include "openplx/Terrain/MaterialLibrary/defaultTerrainMaterial.h"
%include "openplx/Terrain/Terrain.h"
%include "openplx/Terrain/MaterialLibrary/gravel_1.h"
%include "openplx/Terrain/MaterialLibrary/dirt_1.h"
%include "openplx/Terrain/MaterialLibrary/iron_pellets.h"
%include "openplx/Terrain/MaterialLibrary/sand_1.h"
%include "openplx/Terrain/MaterialLibrary/wet_sand.h"
