%module(package="openplx") Sensors
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Sensors/Sensors.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Sensors(Sensors_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Sensors();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Sensors();
OPENPLX_SWIG_BUNDLE_VECTORS_Sensors();
%include "openplx/Sensors/TriaxialRange.h"
%include "openplx/Sensors/Traits/MateAttachment.h"
%include "openplx/Sensors/Traits/LidarFrequency20.h"
%include "openplx/Sensors/Traits/LidarFrequency10.h"
%include "openplx/Sensors/Traits/LidarFrequency05.h"
%include "openplx/Sensors/Signals/TriaxialOutputField.h"
%include "openplx/Sensors/Signals/SensorOutputSignal.h"
%include "openplx/Sensors/Signals/LidarOutputField.h"
%include "openplx/Sensors/Traits/LidarFrequency15.h"
%include "openplx/Sensors/Signals/IMUOutputFieldConstant.h"
%include "openplx/Sensors/SensorLogic.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution2048.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution32.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution1024.h"
%include "openplx/Sensors/Optics/RaySource.h"
%include "openplx/Sensors/Optics/BeamDivergence.h"
%include "openplx/Sensors/Traits/MateConnectorAttachment.h"
%include "openplx/Sensors/Distortion.h"
%include "openplx/Sensors/Optics/Traits/DistortedRayEmission.h"
%include "openplx/Sensors/Optics/Traits/LidarHorizontalResolution512.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution64.h"
%include "openplx/Sensors/Optics/Traits/LidarVerticalResolution128.h"
%include "openplx/Sensors/TriaxialSensorLogic.h"
%include "openplx/Sensors/Signals/IMUOutputField.h"
%include "openplx/Sensors/Optics/HorizontalSweepRaySource.h"
%include "openplx/Sensors/Optics/Traits/RayEmitter.h"
%include "openplx/Sensors/Optics/ConicalBeamDivergence.h"
%include "openplx/Sensors/IMULogic.h"
%include "openplx/Sensors/LidarLogic.h"
%include "openplx/Sensors/MagnetometerSensingDistortion.h"
%include "openplx/Sensors/Optics/RayEmissionDistortion.h"
%include "openplx/Sensors/GyroscopeSensingDistortion.h"
%include "openplx/Sensors/LidarSensingDistortion.h"
%include "openplx/Sensors/AccelerometerSensingDistortion.h"
%include "openplx/Sensors/GyroscopeLogic.h"
%include "openplx/Sensors/MagnetometerLogic.h"
%include "openplx/Sensors/AccelerometerLogic.h"
%include "openplx/Sensors/Optics/Traits/BeamEmitter.h"
%include "openplx/Sensors/Signals/IMUOutput.h"
%include "openplx/Sensors/Signals/LidarOutput.h"
%include "openplx/Sensors/MagnetometerSignalGaussianNoise.h"
%include "openplx/Sensors/MagnetometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/Optics/RayEmissionAngleGaussianNoise.h"
%include "openplx/Sensors/GyroscopeSignalGaussianNoise.h"
%include "openplx/Sensors/GyroscopeSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/GyroscopeSignalLinearAccelectionEffect.h"
%include "openplx/Sensors/LidarDetectionDistanceGaussianNoise.h"
%include "openplx/Sensors/AccelerometerSignalGaussianNoise.h"
%include "openplx/Sensors/AccelerometerSignalSpectralGaussianNoise.h"
%include "openplx/Sensors/Signals/GyroscopeOutput.h"
%include "openplx/Sensors/Signals/MagnetometerOutput.h"
%include "openplx/Sensors/Signals/AccelerometerOutput.h"
%include "openplx/Sensors/Optics/Traits/PulsedBeamEmitter.h"
%include "openplx/Sensors/PulsedLidarLogic.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS2.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OSDome.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM310.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM150.h"
%include "openplx/Sensors/Library/LIDARs/Velodyne/VLP16.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS0.h"
%include "openplx/Sensors/Library/LIDARs/Ouster/OS1.h"
%include "openplx/Sensors/Library/LIDARs/SICK/TIM781.h"
