%module(package="openplx") Math
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Math(Math_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Math();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Math();
OPENPLX_SWIG_BUNDLE_VECTORS_Math();
%include "openplx/Math/Vec3.h"
%include "openplx/Math/Vec2.h"
%include "openplx/Math/Random/GaussianDistribution.h"
%include "openplx/Math/Matrix4x4.h"
%include "openplx/Math/Matrix3x3.h"
%include "openplx/Math/Quat.h"
%include "openplx/Math/Functions.h"
%include "openplx/Math/Line.h"
%include "openplx/Math/AffineTransform.h"
