%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Actuators_Linear()
%import "MachineModeling_Components_Primitive.i"
%import "MachineModeling_Components_Composite.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Actuators_Linear()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Actuators::Linear::Base;
%rename(prefix ## Cylinder) openplx::MachineModeling::Actuators::Linear::Cylinder;
%rename(prefix ## CylinderBearings) openplx::MachineModeling::Actuators::Linear::CylinderBearings;
%rename(prefix ## CylinderPart) openplx::MachineModeling::Actuators::Linear::CylinderPart;
%rename(prefix ## Distance) openplx::MachineModeling::Actuators::Linear::Distance;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear()
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Base);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Cylinder);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::CylinderBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::CylinderPart);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Distance);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear()
%template(MachineModeling_Actuators_Linear_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Cylinder_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_CylinderBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_CylinderPart_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::CylinderPart>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Distance_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear()
%include "openplx/MachineModeling/Actuators/Linear/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/Cylinder.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/CylinderPart.h"
%include "openplx/MachineModeling/Actuators/Linear/Distance.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Actuators_Linear()
%pythoncode %{
from . import Connections
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Actuators_Linear_Connections()
%import "MachineModeling_Connections.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Actuators_Linear_Connections()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear_Connections(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Actuators::Linear::Connections::Base;
%rename(prefix ## Cylinder) openplx::MachineModeling::Actuators::Linear::Connections::Cylinder;
%rename(prefix ## CylinderAxleBearings) openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings;
%rename(prefix ## CylinderBearings) openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings;
%rename(prefix ## Distance) openplx::MachineModeling::Actuators::Linear::Connections::Distance;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear_Connections()
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Base);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Cylinder);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings);
%shared_ptr(openplx::MachineModeling::Actuators::Linear::Connections::Distance);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear_Connections()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear_Connections()
%template(MachineModeling_Actuators_Linear_Connections_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Connections_Cylinder_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Connections_CylinderAxleBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderAxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Connections_CylinderBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::CylinderBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Actuators_Linear_Connections_Distance_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Actuators::Linear::Connections::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear_Connections()
%include "openplx/MachineModeling/Actuators/Linear/Connections/Base.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Cylinder.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderAxleBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/CylinderBearings.h"
%include "openplx/MachineModeling/Actuators/Linear/Connections/Distance.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Actuators_Linear_Connections()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Actuators_Linear_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Actuators_Linear_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Actuators_Linear_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Bearings()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Bearings()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Bearings(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Bearings::Base;
%rename(prefix ## Pair) openplx::MachineModeling::Bearings::Pair;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Bearings()
%shared_ptr(openplx::MachineModeling::Bearings::Base);
%shared_ptr(openplx::MachineModeling::Bearings::Pair);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Bearings()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Bearings::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Bearings::Pair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Bearings()
%template(MachineModeling_Bearings_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Bearings::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Bearings::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Bearings::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Bearings::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Bearings_Pair_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Pair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Pair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Bearings::Pair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Bearings::Pair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Bearings::Pair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Bearings::Pair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Bearings::Pair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Bearings()
%include "openplx/MachineModeling/Bearings/Base.h"
%include "openplx/MachineModeling/Bearings/Pair.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Bearings()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Components_Composite()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Components_Composite()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Composite(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Components::Composite::Base;
%rename(prefix ## LinkPair) openplx::MachineModeling::Components::Composite::LinkPair;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Composite()
%shared_ptr(openplx::MachineModeling::Components::Composite::Base);
%shared_ptr(openplx::MachineModeling::Components::Composite::LinkPair);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Composite()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Composite::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Composite()
%template(MachineModeling_Components_Composite_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Composite::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Components_Composite_LinkPair_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Composite::LinkPair>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Composite()
%include "openplx/MachineModeling/Components/Composite/Base.h"
%include "openplx/MachineModeling/Components/Composite/LinkPair.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Components_Composite()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Components_Primitive()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Components_Primitive()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Components::Primitive::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive()
%shared_ptr(openplx::MachineModeling::Components::Primitive::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive()
%template(MachineModeling_Components_Primitive_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive()
%include "openplx/MachineModeling/Components/Primitive/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Components_Primitive()
%pythoncode %{
from . import Axle
from . import Link
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Components_Primitive_Axle()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Components_Primitive_Axle()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Axle(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Components::Primitive::Axle::Base;
%rename(prefix ## RigidCylindrical) openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Axle()
%shared_ptr(openplx::MachineModeling::Components::Primitive::Axle::Base);
%shared_ptr(openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Axle()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Axle()
%template(MachineModeling_Components_Primitive_Axle_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Components_Primitive_Axle_RigidCylindrical_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::RigidCylindrical>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Axle()
%include "openplx/MachineModeling/Components/Primitive/Axle/Base.h"
%include "openplx/MachineModeling/Components/Primitive/Axle/RigidCylindrical.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Components_Primitive_Axle()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Components_Primitive_Axle_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Components_Primitive_Axle_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Axle_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Axle_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Axle_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Axle_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Axle_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Components_Primitive_Axle_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Components_Primitive_Link()
%import "MachineModeling_Components_Primitive.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Components_Primitive_Link()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Link(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Components::Primitive::Link::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Link()
%shared_ptr(openplx::MachineModeling::Components::Primitive::Link::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Link()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Link()
%template(MachineModeling_Components_Primitive_Link_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Components::Primitive::Link::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Link()
%include "openplx/MachineModeling/Components/Primitive/Link/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Components_Primitive_Link()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Connections()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Connections()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Connections::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections()
%shared_ptr(openplx::MachineModeling::Connections::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections()
%template(MachineModeling_Connections_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections()
%include "openplx/MachineModeling/Connections/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Connections()
%pythoncode %{
from . import Pivot
from . import Universal
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Connections_Interfaces()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Interfaces(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Interfaces()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Connections_Interfaces()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Connections_Pivot()
%import "MachineModeling_Connections.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Connections_Pivot()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Pivot(prefix)
%rename(prefix ## AxleBearings) openplx::MachineModeling::Connections::Pivot::AxleBearings;
%rename(prefix ## Base) openplx::MachineModeling::Connections::Pivot::Base;
%rename(prefix ## Bearings) openplx::MachineModeling::Connections::Pivot::Bearings;
%rename(prefix ## Hinge) openplx::MachineModeling::Connections::Pivot::Hinge;
%rename(prefix ## HingedAxle) openplx::MachineModeling::Connections::Pivot::HingedAxle;
%rename(prefix ## LockedAxleBearings) openplx::MachineModeling::Connections::Pivot::LockedAxleBearings;
%rename(prefix ## LockedBearings) openplx::MachineModeling::Connections::Pivot::LockedBearings;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Pivot()
%shared_ptr(openplx::MachineModeling::Connections::Pivot::AxleBearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Base);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Bearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::Hinge);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::HingedAxle);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::LockedAxleBearings);
%shared_ptr(openplx::MachineModeling::Connections::Pivot::LockedBearings);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Pivot()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Pivot()
%template(MachineModeling_Connections_Pivot_AxleBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::AxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_Bearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Bearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_Hinge_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_HingedAxle_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::HingedAxle>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_LockedAxleBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedAxleBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(MachineModeling_Connections_Pivot_LockedBearings_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Pivot::LockedBearings>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Pivot()
%include "openplx/MachineModeling/Connections/Pivot/Base.h"
%include "openplx/MachineModeling/Connections/Pivot/Hinge.h"
%include "openplx/MachineModeling/Connections/Pivot/HingedAxle.h"
%include "openplx/MachineModeling/Connections/Pivot/AxleBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/Bearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedAxleBearings.h"
%include "openplx/MachineModeling/Connections/Pivot/LockedBearings.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Connections_Pivot()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Connections_Pivot_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Connections_Pivot_Traits()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Pivot_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Pivot_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Pivot_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Pivot_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Pivot_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Connections_Pivot_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Connections_Universal()
%import "MachineModeling_Connections.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Connections_Universal()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Universal(prefix)
%rename(prefix ## Base) openplx::MachineModeling::Connections::Universal::Base;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Universal()
%shared_ptr(openplx::MachineModeling::Connections::Universal::Base);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Universal()
%typemap(out) std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Universal()
%template(MachineModeling_Connections_Universal_Base_Vector) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>), outtype?outtype:$descriptor(std::shared_ptr<openplx::MachineModeling::Connections::Universal::Base>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Universal()
%include "openplx/MachineModeling/Connections/Universal/Base.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Connections_Universal()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_MachineModeling_Constants()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_MachineModeling_Constants()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_MachineModeling_Constants(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Constants()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Constants()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_MachineModeling_Constants()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Constants()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_MachineModeling_Constants()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_MachineModeling()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
#include <openplx/Visuals/Visuals_all.h>
#include <openplx/MachineModeling/MachineModeling_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_MachineModeling()
%import "MachineModeling_Actuators_Linear.i"
%import "MachineModeling_Actuators_Linear_Connections.i"
%import "MachineModeling_Actuators_Linear_Traits.i"
%import "MachineModeling_Bearings.i"
%import "MachineModeling_Components_Composite.i"
%import "MachineModeling_Components_Primitive.i"
%import "MachineModeling_Components_Primitive_Axle.i"
%import "MachineModeling_Components_Primitive_Axle_Traits.i"
%import "MachineModeling_Components_Primitive_Link.i"
%import "MachineModeling_Connections.i"
%import "MachineModeling_Connections_Interfaces.i"
%import "MachineModeling_Connections_Pivot.i"
%import "MachineModeling_Connections_Pivot_Traits.i"
%import "MachineModeling_Connections_Universal.i"
%import "MachineModeling_Constants.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_MachineModeling()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%include <python/Simulation/Simulation.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Simulation();
%include <python/Visuals/Visuals.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Visuals();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_MachineModeling()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%import "Simulation.i"
%import "Visuals.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_MachineModeling(prefix)
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear(prefix ## Actuators_Linear_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear_Connections(prefix ## Actuators_Linear_Connections_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Actuators_Linear_Traits(prefix ## Actuators_Linear_Traits_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Bearings(prefix ## Bearings_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Composite(prefix ## Components_Composite_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive(prefix ## Components_Primitive_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Axle(prefix ## Components_Primitive_Axle_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Axle_Traits(prefix ## Components_Primitive_Axle_Traits_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Components_Primitive_Link(prefix ## Components_Primitive_Link_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections(prefix ## Connections_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Interfaces(prefix ## Connections_Interfaces_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Pivot(prefix ## Connections_Pivot_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Pivot_Traits(prefix ## Connections_Pivot_Traits_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Connections_Universal(prefix ## Connections_Universal_);
OPENPLX_SWIG_NS_RENAMES_MachineModeling_Constants(prefix ## Constants_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_MachineModeling()
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear_Connections();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Actuators_Linear_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Bearings();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Composite();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Axle();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Axle_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Components_Primitive_Link();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Pivot();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Pivot_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Connections_Universal();
OPENPLX_SWIG_NS_SHARED_POINTERS_MachineModeling_Constants();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_MachineModeling()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear_Connections();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Actuators_Linear_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Bearings();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Composite();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Axle();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Axle_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Components_Primitive_Link();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Interfaces();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Pivot();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Pivot_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Connections_Universal();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_MachineModeling_Constants();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_MachineModeling()
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear_Connections();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Actuators_Linear_Traits();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Bearings();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Composite();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Axle();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Axle_Traits();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Components_Primitive_Link();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Interfaces();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Pivot();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Pivot_Traits();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Connections_Universal();
OPENPLX_SWIG_NS_VECTORS_MachineModeling_Constants();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_MachineModeling()
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear_Connections();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Actuators_Linear_Traits();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Bearings();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Composite();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Axle();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Axle_Traits();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Components_Primitive_Link();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Interfaces();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Pivot();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Pivot_Traits();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Connections_Universal();
OPENPLX_SWIG_NS_INCLUDES_MachineModeling_Constants();
%enddef

