#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Geometries/Cylinder.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RigidCylindricalRoadWheelBody */
namespace openplx::Vehicles::Tracks {
    /**
     * A RigidBody with a cylinder shape,
     * to be used by, for example, rigid RoadWheels
     * like the RigidCylindricalIdler, RigidCylindricalRoller or RigidCylindricalSprocket.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT RigidCylindricalRoadWheelBody : public openplx::Physics3D::Bodies::RigidBody {
        protected:
            std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> m_geometry;

        public:
            RigidCylindricalRoadWheelBody();
            virtual ~RigidCylindricalRoadWheelBody();
            std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> geometry() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
