#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Bodies/Inertia.h>
#include <openplx/Math/AffineTransform.h>
#include <openplx/Vehicles/Tracks/DefaultLinkVariation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultLinkDescription */
namespace openplx::Vehicles::Tracks {
    /**
     * Defines the links of a belt of a track system.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT DefaultLinkDescription : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::Inertia> m_inertia;
            std::shared_ptr<openplx::Math::AffineTransform> m_local_cm_transform;
            std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation> m_variation;

        public:
            DefaultLinkDescription();
            virtual ~DefaultLinkDescription();
            std::shared_ptr<openplx::Physics3D::Bodies::Inertia> inertia() const;
            std::shared_ptr<openplx::Math::AffineTransform> local_cm_transform() const;
            std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation> variation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
