#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Vehicles/Tracks/CylindricalRoadWheel.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CylindricalIdler */
namespace openplx::Vehicles::Tracks {
    /**
     * The idler in a tracked system is a wheel, usually at the opposite end of the drive sprocket.
     * If the sprocket is at the rear, the idler is at the front, and vice versa.
     * The idler serves two main purposes.
     * 1. It supports the track in spanning the distance between the front and rear of the vehicle, 
     *    preventing it from sagging excessively or becoming derailed.
     * 2. It often has a mechanism to adjust the track tension,
     *    ensuring the track remains properly seated on all wheels and sprocket.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT CylindricalIdler : public openplx::Vehicles::Tracks::CylindricalRoadWheel {
        protected:

        public:
            CylindricalIdler();
            virtual ~CylindricalIdler();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
