#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model UpForwardVectors */
namespace openplx::Vehicles::Interfaces {
    /**
     *     Two orthogonal vectors that define what is
     *     forward and up for a vehicle or one of its parts.
     *     */
    class OPENPLX_Vehicles_BUNDLE_EXPORT UpForwardVectors {
        public:
            UpForwardVectors();
            virtual ~UpForwardVectors();
            virtual std::shared_ptr<openplx::Math::Vec3> up_vector() const = 0;
            virtual std::shared_ptr<openplx::Math::Vec3> forward_vector() const = 0;
    };
}
