#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Terrain/TerrainBundleExport.h>
#include <openplx/Terrain/TerrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Geometries/Material.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TerrainMaterial */
namespace openplx::Terrain {
    /**
     *     A Terrain Material is a Material that in addition to surface properties from Material also
     *     defines terrain bulk, compaction, excavation and particle properties.
     *
     *     .agx_terrain_material - An annotation to use to tell AGX which Terrain Material source file to use.
     *                             Example: .agx_terrain_material: "DIRT_1"
     *                             This will load the AGX Terrain Material "DIRT_1"
     *
     *     In the current implementation all these parameters are defined by the Physics Engine, e.g. AGX, but later
     *     versions will support defining the parameters here.
     *     */
    class OPENPLX_Terrain_BUNDLE_EXPORT TerrainMaterial : public openplx::Physics::Geometries::Material {
        protected:

        public:
            TerrainMaterial();
            virtual ~TerrainMaterial();
            bool is_default_terrain_material() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
