#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/SensorLogic.h>
#include <openplx/Sensors/TriaxialRange.h>
#include <openplx/Math/Matrix3x3.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TriaxialSensorLogic */
namespace openplx::Sensors {
    /**
     *     Logical functioning of a sensor with three axes of operation.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT TriaxialSensorLogic : public openplx::Sensors::SensorLogic {
        protected:
            std::shared_ptr<openplx::Sensors::TriaxialRange> m_range;
            std::shared_ptr<openplx::Math::Matrix3x3> m_cross_axis_sensitivity;
            std::shared_ptr<openplx::Math::Vec3> m_zero_bias;

        public:
            TriaxialSensorLogic();
            virtual ~TriaxialSensorLogic();
            std::shared_ptr<openplx::Sensors::TriaxialRange> range() const;
            std::shared_ptr<openplx::Math::Matrix3x3> cross_axis_sensitivity() const;
            std::shared_ptr<openplx::Math::Vec3> zero_bias() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
