#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/Optics/Traits/BeamEmitter.h>
/* Generated code for model PulsedBeamEmitter */
namespace openplx::Sensors::Optics::Traits {
    /**
     *     Trait for models that emit (non-continuous) pulsed (non-infinitesimal) beams.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT PulsedBeamEmitter : public openplx::Sensors::Optics::Traits::BeamEmitter {
        public:
            PulsedBeamEmitter();
            virtual ~PulsedBeamEmitter();
            virtual std::shared_ptr<openplx::Sensors::Optics::RaySource> ray_source() const = 0;
            virtual std::shared_ptr<openplx::Sensors::Optics::BeamDivergence> beam_divergence() const = 0;
            virtual double wavelength() const = 0;
    };
}
