#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Links/LinkData.h>
#include <openplx/Robotics/Joints/HingeJointData.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SerialManipulatorData */
namespace openplx::Robotics::Robots {
    class OPENPLX_Robotics_BUNDLE_EXPORT SerialManipulatorData : public openplx::Core::Object {
        protected:
            std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>> m_link_data;
            std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>> m_hinge_data;

        public:
            SerialManipulatorData();
            virtual ~SerialManipulatorData();
            std::vector<std::shared_ptr<openplx::Robotics::Links::LinkData>> link_data() const;
            std::vector<std::shared_ptr<openplx::Robotics::Joints::HingeJointData>> hinge_data() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
