#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/Math/AffineTransform.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model ElementaryTransform */
namespace openplx::Robotics::Kinematics {
    class OPENPLX_Robotics_BUNDLE_EXPORT ElementaryTransform : public openplx::Core::Object {
        protected:
            std::string m_type;
            double m_c;
            bool m_free;
            bool m_flip;

        public:
            ElementaryTransform();
            virtual ~ElementaryTransform();
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> tx(double x);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> ty(double y);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> tz(double z);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Rx(double theta);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Ry(double theta);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Rz(double theta);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> tx_free(bool flip);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> ty_free(bool flip);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> tz_free(bool flip);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Rx_free(bool flip);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Ry_free(bool flip);
            static std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform> Rz_free(bool flip);
            static std::vector<std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform>> calculateElementaryTransformSequence(std::shared_ptr<openplx::Physics3D::System> system, std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> base, std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> end);
            static std::shared_ptr<openplx::Math::AffineTransform> fkine(std::vector<std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform>> ets, std::vector<double> q);
            static std::shared_ptr<openplx::Math::Vec3> position_from_ets(std::vector<std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform>> ets, int64_t joint_index);
            static std::shared_ptr<openplx::Math::Vec3> main_axis_from_ets(std::vector<std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform>> ets, int64_t joint_index);
            static std::shared_ptr<openplx::Math::Vec3> normal_from_ets(std::vector<std::shared_ptr<openplx::Robotics::Kinematics::ElementaryTransform>> ets, int64_t joint_index);
            std::string type() const;
            double c() const;
            bool free() const;
            bool flip() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
