#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Marshalling.h>
#include <openplx/Physics/Signals/RealField.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Vec3Marshalling */
namespace openplx::Physics3D::Signals {
    class OPENPLX_Physics3D_BUNDLE_EXPORT Vec3Marshalling : public openplx::Physics::Signals::Marshalling {
        protected:
            std::shared_ptr<openplx::Physics::Signals::RealField> m_x;
            std::shared_ptr<openplx::Physics::Signals::RealField> m_y;
            std::shared_ptr<openplx::Physics::Signals::RealField> m_z;

        public:
            Vec3Marshalling();
            virtual ~Vec3Marshalling();
            std::shared_ptr<openplx::Physics::Signals::RealField> x() const;
            std::shared_ptr<openplx::Physics::Signals::RealField> y() const;
            std::shared_ptr<openplx::Physics::Signals::RealField> z() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
