#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultPrismaticToughness.h>
#include <openplx/Physics/Interactions/Toughness/ThresholdFracture.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model PrismaticThresholdFracture */
namespace openplx::Physics3D::Interactions::Toughness {
    /**
     *     Define a threshold fracture model for each constrained degree of freedom for a Prismatic.
     *     Each dimension can then fail individually at their fracture points. 
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT PrismaticThresholdFracture : public openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness {
        protected:
            double m_default_limit;

        public:
            PrismaticThresholdFracture();
            virtual ~PrismaticThresholdFracture();
            double default_limit() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> along_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> along_cross() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> around_main() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> around_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Toughness::ThresholdFracture> around_cross() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
