#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SpringInteraction1DOF */
namespace openplx::Physics3D::Interactions {
    /**
     *     A spring that obeys Hookes law, F = -k * x.
     *     The k is defined by the stiffness off the Elastic deformation model.
     *     The Spring can also add a damping term, by specifying the damping model.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT SpringInteraction1DOF : public openplx::Physics::Interactions::Interaction1DOF {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;

        public:
            SpringInteraction1DOF();
            virtual ~SpringInteraction1DOF();
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
