#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RangeInteraction1DOF */
namespace openplx::Physics3D::Interactions {
    /**
     *     A limit range, for where the degree of freedom is bound.
     *     The boundary conditions are considered one dimensional walls,
     *     with which the two involved bodies will collide, if violated.
     *     The interaction when bumping in to the range defined with an ElasticityType.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT RangeInteraction1DOF : public openplx::Physics::Interactions::Interaction1DOF {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;
            double m_start;
            double m_end;

        public:
            RangeInteraction1DOF();
            virtual ~RangeInteraction1DOF();
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            double start() const;
            double end() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
