#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultMateDissipation.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DefaultLockDissipation */
namespace openplx::Physics3D::Interactions::Dissipation {
    /**
     *     Defines one dissipation model for each constrained degree of freedom for a Lock
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT DefaultLockDissipation : public openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_along_main;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_along_normal;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_along_cross;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_around_main;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_around_normal;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_around_cross;

        public:
            DefaultLockDissipation();
            virtual ~DefaultLockDissipation();
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> along_main() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> along_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> along_cross() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> around_main() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> around_normal() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> around_cross() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
