#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Value.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Vec3Value */
namespace openplx::Physics::Signals {
    /**
     * Base for Values that are real Vec3s
     **/
    class OPENPLX_Physics_BUNDLE_EXPORT Vec3Value : public openplx::Physics::Signals::Value {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_value;

        public:
            Vec3Value();
            virtual ~Vec3Value();
            std::shared_ptr<openplx::Math::Vec3> value() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
