#pragma once

#include <openplx/Types.h>

namespace openplx::SyntaxError {
    constexpr error_code_t ExpectedDeclarationName = 10001; // Deprecated
    constexpr error_code_t ExpectedMembers = 10002;
    constexpr error_code_t ExpectedIndentedBlock = 10003;
    constexpr error_code_t UnexpectedCharacter = 10004;
    constexpr error_code_t ExpectedIdentifier = 10005;
    constexpr error_code_t UnexpectedIndentation = 10006;
    constexpr error_code_t UnexpectedToken = 10007;
    constexpr error_code_t UnexpectedEndOfLine = 10008;
    constexpr error_code_t ExpectedReturnType = 10009;
    constexpr error_code_t ExpectedSymbol = 10010;
    constexpr error_code_t ExpectedValue = 10011;
    constexpr error_code_t ExpectedIs = 10012;
    constexpr error_code_t ExpectedType = 10013;
    constexpr error_code_t UnexpectedEndOfFile = 10014;
    constexpr error_code_t ExpectedColon = 10015;
    constexpr error_code_t InvalidExpression = 10016;
    constexpr error_code_t UnterminatedString = 10017;
    constexpr error_code_t ExpectedOperator = 10018;
    constexpr error_code_t TooComplexAnnotationExpression = 10019;
    constexpr error_code_t InvalidModelQualifier = 10020;
    constexpr error_code_t InvalidIdentifierString = 10021;
    constexpr error_code_t NoPluginForImportedFile = 10022;
    constexpr error_code_t ImportedFileNotFound = 10023;
    constexpr error_code_t ComplexTypeExpressionsNotAllowed = 10024;
    constexpr error_code_t InvalidDollarString = 10025;
}

namespace openplx::SemanticError {
    constexpr error_code_t TypeNotFound = 20001;
    constexpr error_code_t VariableNotFound = 20002;
    constexpr error_code_t MethodNotFound = 20003;
    constexpr error_code_t MemberNotFound = 20004;
    constexpr error_code_t TypeMismatch = 20005;
    constexpr error_code_t SymbolAlreadyDefined = 20006;
    constexpr error_code_t SymbolAlreadyAssigned = 20007;
    /**
     * Never use explicitly, use CycleFoundError::create
     */
    constexpr error_code_t CycleFound = 20008;
    constexpr error_code_t WrongNumberOfArguments = 20009;
    constexpr error_code_t InvalidNumberOfParameters = 20010;
    constexpr error_code_t OperatorAlreadyDefined = 20011;
    constexpr error_code_t AssignedVarInConstModel = 20012;
    constexpr error_code_t MissingConstWhenParentConst = 20013;
    constexpr error_code_t NestedDeclarationsNotAllowed = 20014;
    constexpr error_code_t ExpectedTrait = 20015;
    constexpr error_code_t NestedTraitsNotAllowed = 20016;
    constexpr error_code_t TraitsWithCommonAncestorNotAllowed = 20017;
    constexpr error_code_t AssignedVarInTrait = 20018;
    constexpr error_code_t ReferencesAreReadOnly = 20019;
    constexpr error_code_t ReferencesMustBeModels = 20020;
    constexpr error_code_t ReferencesCannotBecome = 20021;
    constexpr error_code_t MissingSpecialization = 20022;
    constexpr error_code_t OptionalCannotBecome = 20023;
    constexpr error_code_t InvalidDocumentSeparator = 20024;
    constexpr error_code_t RhsMustBeReference = 20025;
}

namespace openplx::RuntimeError {
    constexpr error_code_t DivisionByZero = 30001;
    constexpr error_code_t NotInstantiated = 30002;
    /**
     * Never use explicitly, use MissingAssignmentError::create
     */
    constexpr error_code_t MissingAssignment = 30003;
    constexpr error_code_t CircularDependency = 30004;
    constexpr error_code_t IndexOutOfBounds = 30005;
    constexpr error_code_t MissingImplementation = 30006;
    constexpr error_code_t IntOutOfBounds = 30007;
    constexpr error_code_t ModelDeclarationNotFound = 30008;
    constexpr error_code_t FileNotFound = 30009;
    constexpr error_code_t ModelNotInitializable = 30010;
    constexpr error_code_t DependencyNotSatisfied = 30011;
}
