#pragma once

#include <filesystem>
#include <ostream>
#include <string>
#include <memory>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/BundleConfig.h>
#include <openplx/Type.h>

namespace openplx
{
    class MustacheGeneratorImpl;

    /**
     * Mustache is a logic-less template system, basically no if-statements in the templates.
     * The openplx generator will populate the template data objects with everything needed to
     * generate artifacts for a bundle. This allows decoupling of the generated artifacts from
     * the generator by allowing us to create mustache templates for for example .md, .i, .pyi
     * files etc. The end users can also use it to generate custom artifacts from bundles.
     */
    class MustacheGenerator
    {
        public:

            MustacheGenerator();
            ~MustacheGenerator();

            void generate_for_bundle(
                std::string tmpl,
                openplx::Core::Api::OpenPlxContext& openplx_context,
                Bundle::BundleConfig& bundle_config,
                const std::filesystem::path& output_path
            );

            void generate_for_all_bundles(
                std::string tmpl,
                openplx::Core::Api::OpenPlxContext& openplx_context,
                std::vector<Bundle::BundleConfig>& bundle_configs,
                const std::filesystem::path& output_path
            );

            void generate_for_structs(
                std::string tmpl,
                std::string suffix,
                openplx::Core::Api::OpenPlxContext& openplx_context,
                const std::filesystem::path& output_path
            );

        private:
            std::unique_ptr<MustacheGeneratorImpl> m_pimpl;
    };
}
