#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Connections/Pivot/Hinge.h>
#include <openplx/MachineModeling/Connections/Pivot/Traits/Bearings.h>
#include <openplx/Physics3D/Interactions/Cylindrical.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Bearings */
namespace openplx::MachineModeling::Connections::Pivot {
    /**
     *     A Bearing connection specializes the simple Hinge connection
     *     to have two Mates instead of one, one for each bearing.
     *
     *     This Bearing connection does not have the concept of an axle,
     *     instead each side both have a pearing pair,
     *     and they should both have the same separation.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Bearings : public openplx::MachineModeling::Connections::Pivot::Hinge, public openplx::MachineModeling::Connections::Pivot::Traits::Bearings {
        protected:
            std::shared_ptr<openplx::Simulation::CollisionGroup> m_bearing_collision_group;
            std::shared_ptr<openplx::Simulation::DisableCollisionPair> m_disable_bearings;
            std::weak_ptr<openplx::MachineModeling::Bearings::Pair> m_from_bearings;
            std::weak_ptr<openplx::MachineModeling::Bearings::Pair> m_to_bearings;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> m_left_mate;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> m_right_mate;

        public:
            Bearings();
            virtual ~Bearings();
            std::shared_ptr<openplx::Simulation::CollisionGroup> bearing_collision_group() const override;
            std::shared_ptr<openplx::Simulation::DisableCollisionPair> disable_bearings() const override;
            std::shared_ptr<openplx::MachineModeling::Bearings::Pair> from_bearings() const override;
            std::shared_ptr<openplx::MachineModeling::Bearings::Pair> to_bearings() const override;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> left_mate() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> right_mate() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
