#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Components/Primitive/Base.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Base */
namespace openplx::MachineModeling::Components::Primitive::Link {
    /**
     *     The Base Link has two connectors
     *     intended to connect the link between two other components.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Base : public openplx::MachineModeling::Components::Primitive::Base {
        protected:
            double m_bearing_separation;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_connector_1;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_connector_2;

        public:
            Base();
            virtual ~Base();
            double bearing_separation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> connector_1() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> connector_2() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
