#pragma once

#include <memory>

namespace openplx {

    class Marshalling;

    namespace Physics::Signals {
        class Input;
    }

    class InputHandler {
        public:
            virtual ~InputHandler() = default;

            /**
             * If the marshalling has no buffer the input handler
             * should populate the size and offsets in the marshalling
             * fields and set the required buffer size.
             *
             * @returns true if the marshalling was updated correctly with the input state, false otherwise
             */
            virtual bool handle(
                const std::shared_ptr<Physics::Signals::Input>& input,
                const std::shared_ptr<Marshalling>& marshalling) = 0;
    };
}
