#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Control/ControlBundleExport.h>
#include <openplx/Control/ControlForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Input.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AffineTransform1DInput */
namespace openplx::Control::Virtual {
    /**
     * A virtual input control that multiplies a single real field
     * with a scale factor and adds an offset and then forwards to another
     * input with a matching real field.
     **/
    class OPENPLX_Control_BUNDLE_EXPORT AffineTransform1DInput : public openplx::Physics::Signals::Input {
        protected:
            std::string m_field_name;
            double m_scale;
            double m_offset;
            std::weak_ptr<openplx::Physics::Signals::Input> m_target;

        public:
            AffineTransform1DInput();
            virtual ~AffineTransform1DInput();
            std::string field_name() const;
            double scale() const;
            double offset() const;
            std::shared_ptr<openplx::Physics::Signals::Input> target() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
