/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agx/config/AGX_USE_AGXTERRAIN.h>
#include <agxTerrain/ActiveZone.h>
#include <agxTerrain/TerrainToolUtils.h>

namespace agxTerrain
{
  class Shovel;
  class Terrain;

  AGX_DECLARE_POINTER_TYPES( PrimaryActiveZone );

  class AGXTERRAIN_EXPORT PrimaryActiveZone : public ActiveZone
  {
  public:
    PrimaryActiveZone( agx::Frame* parentFrame, Shovel* shovel, const agxCollide::GeometryRefVector& voxelCollisionGeometries );

    ActiveZone::Type getType() const;

    const agxCollide::Convex* getInnerShape() const;

    const agxCollide::Convex* getTeethInnerShape() const;

    const agx::Vector<agx::Plane>& getInnerPlanes() const;

    const agx::Vector<agx::Plane>& getTeethInnerPlanes() const;

    void onPreCollide( Terrain* terrain, const agx::Line& cuttingEdge, const agx::Line& topEdge, const agx::Vec3& forwardVector );

    void onPre( Terrain* terrain, const agx::Line& cuttingEdge, const agx::Line& topEdge, const agx::Vec3& forwardVector );

    void onPost( Terrain* terrain, const agx::Line& cuttingEdge, const agx::Line& topEdge, const agx::Vec3& forwardVector );

    agx::Real getSecondarySeparationAngle() const;

    agx::Vec3 getSecondaryForwardDirectionWorld() const;

    void updateInnerShape( const agxCollide::GeometryRefVector& voxelCollisionGeometries );

    void setSplittingPlane( const agx::Plane& plane );

    void debugDrawInnerShapes();

  protected:
    virtual ~PrimaryActiveZone();

  private:

    bool createInnerShape( Shovel* shovel, const agxCollide::GeometryRefVector& voxelCollisionGeometries );
    bool createTeethInnerShape( Shovel* shovel );

    bool finalizeInnerShapeFromVertices( const agx::Vec3Vector& vertices );

    void calculateSecondarySeparationProperties( Shovel* shovel );

    void calculateProjectedVectors(
      const agx::Line& cuttingEdge,
      const agx::Line& topEdge,
      const agx::Vec3& forwardVector,
      agx::Line& cuttingEdgeWorld,
      agx::Line& topEdgeWorld );

    agx::Vec3Vector performSecondIntersectionTest(
      agx::Vec3Vector& vertices,
      const MeshTransformPairVector& meshes,
      const agx::Vec3& center,
      const agx::Plane& cutTopPlane,
      const agx::Plane& lowerCuttingEdgePlane,
      agx::Real threshold,
      bool dbgRender );

  private:
    // Active zone geometry and inner-shape
    agxCollide::ConvexRef m_innerShape;
    agxCollide::ConvexRef m_teethInnerShape;

    // Planes used to sort particles
    agx::Vector<agx::Plane> m_innerPlanes;
    agx::Vector<agx::Plane> m_teethInnerPlanes;

    // Pointer to shovel
    Shovel* m_shovel;

    // Secondary separation
    agx::Real m_secondarySeparationAngle;
    agx::Vec3 m_secondaryForwardVectorWorld;

    // Projected vectors
    agx::Vec3 m_projectedForwardVectorWorld;
    agx::Vec3 m_projectedSecondaryForwardVectorWorld;
    agx::Vec3 m_flatForwardVectorWorld;
  };
}
