/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/RaytraceSystemNodeProxy.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( RtOutputNoise );
  AGX_DECLARE_VECTOR_TYPES( RtOutputNoise );

  /**
  Defines a noise that is applied to Lidar output data.
  */
  class AGXSENSOR_EXPORT RtOutputNoise : public IRtSystemNode
  {
    public:
      /**
      \return true if data is dirty and has to be syncrhonized, otherwise false
      */
      bool isDirty() const;

      /**
      True to trigger synchronization of data.
      \param dirty - true to synchronize data
      */
      void setDirty( bool dirty );

    public:
      /**
      Called one time when getDirty() == true during synchronization. Override
      'synchronize' for continuous calling.
      */
      virtual void update( RtNode* node, const CallbackData& data );

      /**
      Checks dirty flag before calling update(const CallbackData&) and
      resets the dirty flag after that.
      */
      virtual void synchronize( RtNode* node, const CallbackData& data ) final override;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual void store( agxStream::OutputArchive& out ) const override;
      virtual void restore( agxStream::InputArchive& in ) override;
      
      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      bool m_dirty{ false };
  };
}
