/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxPlot/DataGenerator.h>

#include <agxSDK/EventListener.h>

namespace agxPlot
{
  /**
  Event listener that will generate plotting data
  */
  class AGXPHYSICS_EXPORT DataListener : public agxSDK::EventListener
  {
    public:
      DataListener();

      virtual DataGenerator::Result getValue();

    protected:
      /// Destructor
      virtual ~DataListener();
  };
  AGX_DECLARE_POINTER_TYPES(DataListener);


  /**
  Callback class for generating data to be plotted
  */
  class AGXPHYSICS_EXPORT CallbackDataGenerator : public DataGenerator
  {
  public:
    CallbackDataGenerator(DataListener* callback);

    virtual DataGenerator::Result getValue();

  protected:
    /// Destructor
    virtual ~CallbackDataGenerator();

  private:
    DataListenerRef m_callback;
  };


  /**
  Class that produces data in the form of a Real value.
  */
  class AGXPHYSICS_EXPORT RealCallbackDataGenerator : public DataGenerator
  {
  public:
    RealCallbackDataGenerator();

    /// Implement and return the value to be plotted.
    virtual agx::Real get() = 0;    

  protected:
    virtual DataGenerator::Result getValue();
    
    /// Destructor
    virtual ~RealCallbackDataGenerator();
  };

}
