// Copyright Epic Games, Inc. All Rights Reserved.
/*===========================================================================
	Generated code exported from UnrealHeaderTool.
	DO NOT modify this manually! Edit the corresponding .h files instead!
===========================================================================*/

#include "UObject/GeneratedCppIncludes.h"
#include "Constraints/Controllers/AGX_TwistRangeController.h"
#include "AGX_RealInterval.h"

PRAGMA_DISABLE_DEPRECATION_WARNINGS
static_assert(!UE_WITH_CONSTINIT_UOBJECT, "This generated code can only be compiled with !UE_WITH_CONSTINIT_OBJECT");
void EmptyLinkFunctionForGeneratedCodeAGX_TwistRangeController() {}

// ********** Begin Cross Module References ********************************************************
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_TwistRangeController_FL();
AGXUNREAL_API UClass* Z_Construct_UClass_UAGX_TwistRangeController_FL_NoRegister();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_ElementaryConstraint();
AGXUNREAL_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_TwistRangeController();
AGXUNREALBARRIER_API UScriptStruct* Z_Construct_UScriptStruct_FAGX_RealInterval();
ENGINE_API UClass* Z_Construct_UClass_UBlueprintFunctionLibrary();
UPackage* Z_Construct_UPackage__Script_AGXUnreal();
// ********** End Cross Module References **********************************************************

// ********** Begin ScriptStruct FAGX_TwistRangeController *****************************************
struct Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics
{
	static inline consteval int32 GetStructSize() { return sizeof(FAGX_TwistRangeController); }
	static inline consteval int16 GetStructAlignment() { return alignof(FAGX_TwistRangeController); }
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Struct_MetaDataParams[] = {
		{ "BlueprintType", "true" },
		{ "Comment", "/**\n * A Twist Range Controller limits the range of relative rotation between two Rigid Bodies. It is\n * only available on Constraint Components that allow for multiple axes of rotation of which one\n * is the twist axis. Ball Constraint is an example of such a Constraint Component. Hinge is not\n * since it only allows for rotation around a single axis and therefore has a Range Controller\n * instead.\n *\n * Twist is defined to be rotation around the constraint's Z axis.\n *\n * This type cannot be used to create new native AGX Dynamics instances of the Twist Range\n * Controller, it is only used to access a Twist Range Controller that exists on a constraint such\n * as Ball Constraint.\n *\n */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "A Twist Range Controller limits the range of relative rotation between two Rigid Bodies. It is\nonly available on Constraint Components that allow for multiple axes of rotation of which one\nis the twist axis. Ball Constraint is an example of such a Constraint Component. Hinge is not\nsince it only allows for rotation around a single axis and therefore has a Range Controller\ninstead.\n\nTwist is defined to be rotation around the constraint's Z axis.\n\nThis type cannot be used to create new native AGX Dynamics instances of the Twist Range\nController, it is only used to access a Twist Range Controller that exists on a constraint such\nas Ball Constraint." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Range_MetaData[] = {
		{ "Category", "AGX Twist Range Controller" },
		{ "Comment", "/**\n\x09 * The amount of rotation around the constraint's Z axis that is allowed [deg].\n\x09 */" },
		{ "EditCondition", "bEnable" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "The amount of rotation around the constraint's Z axis that is allowed [deg]." },
	};
#endif // WITH_METADATA

// ********** Begin ScriptStruct FAGX_TwistRangeController constinit property declarations *********
	static const UECodeGen_Private::FStructPropertyParams NewProp_Range;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End ScriptStruct FAGX_TwistRangeController constinit property declarations ***********
	static void* NewStructOps()
	{
		return (UScriptStruct::ICppStructOps*)new UScriptStruct::TCppStructOps<FAGX_TwistRangeController>();
	}
	static const UECodeGen_Private::FStructParams StructParams;
}; // struct Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics
static_assert(std::is_polymorphic<FAGX_TwistRangeController>() == std::is_polymorphic<FAGX_ElementaryConstraint>(), "USTRUCT FAGX_TwistRangeController cannot be polymorphic unless super FAGX_ElementaryConstraint is polymorphic");
static FStructRegistrationInfo Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController;
class UScriptStruct* FAGX_TwistRangeController::StaticStruct()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.OuterSingleton)
	{
		Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.OuterSingleton = GetStaticStruct(Z_Construct_UScriptStruct_FAGX_TwistRangeController, (UObject*)Z_Construct_UPackage__Script_AGXUnreal(), TEXT("AGX_TwistRangeController"));
	}
	return Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.OuterSingleton;
	}

// ********** Begin ScriptStruct FAGX_TwistRangeController Property Definitions ********************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::NewProp_Range = { "Range", nullptr, (EPropertyFlags)0x0010000000000001, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(FAGX_TwistRangeController, Range), Z_Construct_UScriptStruct_FAGX_RealInterval, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Range_MetaData), NewProp_Range_MetaData) }; // 3120101040
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::NewProp_Range,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::PropPointers) < 2048);
// ********** End ScriptStruct FAGX_TwistRangeController Property Definitions **********************
const UECodeGen_Private::FStructParams Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::StructParams = {
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
	Z_Construct_UScriptStruct_FAGX_ElementaryConstraint,
	&NewStructOps,
	"AGX_TwistRangeController",
	Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::PropPointers,
	UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::PropPointers),
	sizeof(FAGX_TwistRangeController),
	alignof(FAGX_TwistRangeController),
	RF_Public|RF_Transient|RF_MarkAsNative,
	EStructFlags(0x00000201),
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::Struct_MetaDataParams), Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::Struct_MetaDataParams)
};
UScriptStruct* Z_Construct_UScriptStruct_FAGX_TwistRangeController()
{
	if (!Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.InnerSingleton)
	{
		UECodeGen_Private::ConstructUScriptStruct(Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.InnerSingleton, Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::StructParams);
	}
	return CastChecked<UScriptStruct>(Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController.InnerSingleton);
}
// ********** End ScriptStruct FAGX_TwistRangeController *******************************************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetCompliance **********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics
{
	struct AGX_TwistRangeController_FL_eventGetCompliance_Parms
	{
		FAGX_TwistRangeController Constraint;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Get the Compliance from othe Elementary Constraint. [m/N] for translational DOFs and [rad/Nm]\n\x09 * for rotational DOFs.\n\x09 * @param Constraint The Elementary Constraint to get Compliance from.\n\x09 * @return The Compliance of the Elementary Constraint.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the Compliance from othe Elementary Constraint. [m/N] for translational DOFs and [rad/Nm]\nfor rotational DOFs.\n@param Constraint The Elementary Constraint to get Compliance from.\n@return The Compliance of the Elementary Constraint." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetCompliance constinit property declarations *************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetCompliance constinit property declarations ***************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetCompliance Property Definitions ************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetCompliance_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetCompliance_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::PropPointers) < 2048);
// ********** End Function GetCompliance Property Definitions **************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetCompliance", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::AGX_TwistRangeController_FL_eventGetCompliance_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::AGX_TwistRangeController_FL_eventGetCompliance_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetCompliance)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_TwistRangeController_FL::GetCompliance(Z_Param_Out_Constraint);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetCompliance ************************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetEnable **************************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics
{
	struct AGX_TwistRangeController_FL_eventGetEnable_Parms
	{
		FAGX_TwistRangeController Constraint;
		bool ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Check whether the given Elementary Constraint is enabled or disabled.\n\x09 * @param Constraint The Elementary Constraint to check.\n\x09 * @return True if the Elementary Constraint is enabled, false otherwise.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Check whether the given Elementary Constraint is enabled or disabled.\n@param Constraint The Elementary Constraint to check.\n@return True if the Elementary Constraint is enabled, false otherwise." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetEnable constinit property declarations *****************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static void NewProp_ReturnValue_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetEnable constinit property declarations *******************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetEnable Property Definitions ****************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetEnable_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
void Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_ReturnValue_SetBit(void* Obj)
{
	((AGX_TwistRangeController_FL_eventGetEnable_Parms*)Obj)->ReturnValue = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_TwistRangeController_FL_eventGetEnable_Parms), &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_ReturnValue_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::PropPointers) < 2048);
// ********** End Function GetEnable Property Definitions ******************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetEnable", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::AGX_TwistRangeController_FL_eventGetEnable_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::AGX_TwistRangeController_FL_eventGetEnable_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetEnable)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(bool*)Z_Param__Result=UAGX_TwistRangeController_FL::GetEnable(Z_Param_Out_Constraint);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetEnable ****************************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetForceRange **********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics
{
	struct AGX_TwistRangeController_FL_eventGetForceRange_Parms
	{
		FAGX_TwistRangeController Constraint;
		double Min;
		double Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Get the Force Range of the Elementary Constraint  [N] or [Nm].\n\x09 * @param Constraint The Elementary Constraint to get the Force Range for.\n\x09 * @param Min The minimum force or torque the constraint can apply [N] or [Nm].\n\x09 * @param Max The maximum force or torque the constraint can apply [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the Force Range of the Elementary Constraint  [N] or [Nm].\n@param Constraint The Elementary Constraint to get the Force Range for.\n@param Min The minimum force or torque the constraint can apply [N] or [Nm].\n@param Max The maximum force or torque the constraint can apply [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetForceRange constinit property declarations *************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Min;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetForceRange constinit property declarations ***************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetForceRange Property Definitions ************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRange_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000180, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000180, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::PropPointers) < 2048);
// ********** End Function GetForceRange Property Definitions **************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetForceRange", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::AGX_TwistRangeController_FL_eventGetForceRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::AGX_TwistRangeController_FL_eventGetForceRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetForceRange)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY_REF(FDoubleProperty,Z_Param_Out_Min);
	P_GET_PROPERTY_REF(FDoubleProperty,Z_Param_Out_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::GetForceRange(Z_Param_Out_Constraint,Z_Param_Out_Min,Z_Param_Out_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetForceRange ************************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetForceRangeMax *******************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics
{
	struct AGX_TwistRangeController_FL_eventGetForceRangeMax_Parms
	{
		FAGX_TwistRangeController Constraint;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Get the maximum force or torque the Elementary Constraint can apply [N] or [Nm].\n\x09 * @param Constraint The Elementary Constraint to get the maximum force range for.\n\x09 * @return The maximum force or torque the Elementary Constraint can apply [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the maximum force or torque the Elementary Constraint can apply [N] or [Nm].\n@param Constraint The Elementary Constraint to get the maximum force range for.\n@return The maximum force or torque the Elementary Constraint can apply [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetForceRangeMax constinit property declarations **********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetForceRangeMax constinit property declarations ************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetForceRangeMax Property Definitions *********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRangeMax_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRangeMax_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::PropPointers) < 2048);
// ********** End Function GetForceRangeMax Property Definitions ***********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetForceRangeMax", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::AGX_TwistRangeController_FL_eventGetForceRangeMax_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::AGX_TwistRangeController_FL_eventGetForceRangeMax_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetForceRangeMax)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_TwistRangeController_FL::GetForceRangeMax(Z_Param_Out_Constraint);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetForceRangeMax *********************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetForceRangeMin *******************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics
{
	struct AGX_TwistRangeController_FL_eventGetForceRangeMin_Parms
	{
		FAGX_TwistRangeController Constraint;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Get the minimum force or torque the Elementary Constraint can apply [N] or [Nm].\n\x09 * @param Constraint The Elementary Constraint to get the minimum force range for.\n\x09 * @return The minimum force or torque the Elementary Constraint can apply [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the minimum force or torque the Elementary Constraint can apply [N] or [Nm].\n@param Constraint The Elementary Constraint to get the minimum force range for.\n@return The minimum force or torque the Elementary Constraint can apply [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetForceRangeMin constinit property declarations **********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetForceRangeMin constinit property declarations ************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetForceRangeMin Property Definitions *********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRangeMin_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetForceRangeMin_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::PropPointers) < 2048);
// ********** End Function GetForceRangeMin Property Definitions ***********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetForceRangeMin", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::AGX_TwistRangeController_FL_eventGetForceRangeMin_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::AGX_TwistRangeController_FL_eventGetForceRangeMin_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetForceRangeMin)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_TwistRangeController_FL::GetForceRangeMin(Z_Param_Out_Constraint);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetForceRangeMin *********************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetRange ***************************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics
{
	struct AGX_TwistRangeController_FL_eventGetRange_Parms
	{
		FAGX_TwistRangeController Controller;
		double Min;
		double Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Twist Range Controller" },
		{ "Comment", "/**\n\x09 * Get the range of angles that the two constrained bodies may twist relative to each other\n\x09 * [deg].\n\x09 * @param Controller The Twist Range Controller to get allowed angle range from.\n\x09 * @param Min The minimum angle allowed [deg].\n\x09 * @param Max The maximum angle allowed [deg].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the range of angles that the two constrained bodies may twist relative to each other\n[deg].\n@param Controller The Twist Range Controller to get allowed angle range from.\n@param Min The minimum angle allowed [deg].\n@param Max The maximum angle allowed [deg]." },
	};
	static constexpr UECodeGen_Private::FMetaDataPairParam NewProp_Controller_MetaData[] = {
		{ "NativeConst", "" },
	};
#endif // WITH_METADATA

// ********** Begin Function GetRange constinit property declarations ******************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Min;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetRange constinit property declarations ********************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetRange Property Definitions *****************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000182, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetRange_Parms, Controller), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(UE_ARRAY_COUNT(NewProp_Controller_MetaData), NewProp_Controller_MetaData) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000180, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000180, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::PropPointers) < 2048);
// ********** End Function GetRange Property Definitions *******************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetRange", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::AGX_TwistRangeController_FL_eventGetRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x14442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::AGX_TwistRangeController_FL_eventGetRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetRange)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Controller);
	P_GET_PROPERTY_REF(FDoubleProperty,Z_Param_Out_Min);
	P_GET_PROPERTY_REF(FDoubleProperty,Z_Param_Out_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::GetRange(Z_Param_Out_Controller,Z_Param_Out_Min,Z_Param_Out_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetRange *****************************

// ********** Begin Class UAGX_TwistRangeController_FL Function GetSpookDamping ********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics
{
	struct AGX_TwistRangeController_FL_eventGetSpookDamping_Parms
	{
		FAGX_TwistRangeController Constraint;
		double ReturnValue;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Get the Spook damping time from the Elementary Constraint [s].\n\x09 * @param Constraint The Elementary Constraint to get Spook damping from.\n\x09 * @return The Spook damping of the Elementary Constraint.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Get the Spook damping time from the Elementary Constraint [s].\n@param Constraint The Elementary Constraint to get Spook damping from.\n@return The Spook damping of the Elementary Constraint." },
	};
#endif // WITH_METADATA

// ********** Begin Function GetSpookDamping constinit property declarations ***********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_ReturnValue;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function GetSpookDamping constinit property declarations *************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function GetSpookDamping Property Definitions **********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetSpookDamping_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::NewProp_ReturnValue = { "ReturnValue", nullptr, (EPropertyFlags)0x0010000000000580, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventGetSpookDamping_Parms, ReturnValue), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::NewProp_ReturnValue,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::PropPointers) < 2048);
// ********** End Function GetSpookDamping Property Definitions ************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "GetSpookDamping", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::AGX_TwistRangeController_FL_eventGetSpookDamping_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::AGX_TwistRangeController_FL_eventGetSpookDamping_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execGetSpookDamping)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_FINISH;
	P_NATIVE_BEGIN;
	*(double*)Z_Param__Result=UAGX_TwistRangeController_FL::GetSpookDamping(Z_Param_Out_Constraint);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function GetSpookDamping **********************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetCompliance **********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics
{
	struct AGX_TwistRangeController_FL_eventSetCompliance_Parms
	{
		FAGX_TwistRangeController Constraint;
		double Compliance;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Set the compliance of an Elementary Constraint. [m/N] for translational DOFs and [rad/Nm] for\n\x09 * rotational DOFs.\n\x09 * @param Constraint The Elementary Constraint to set Compliance on.\n\x09 * @param Compliance The new Compliance.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the compliance of an Elementary Constraint. [m/N] for translational DOFs and [rad/Nm] for\nrotational DOFs.\n@param Constraint The Elementary Constraint to set Compliance on.\n@param Compliance The new Compliance." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetCompliance constinit property declarations *************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Compliance;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetCompliance constinit property declarations ***************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetCompliance Property Definitions ************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetCompliance_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::NewProp_Compliance = { "Compliance", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetCompliance_Parms, Compliance), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::NewProp_Compliance,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::PropPointers) < 2048);
// ********** End Function SetCompliance Property Definitions **************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetCompliance", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::AGX_TwistRangeController_FL_eventSetCompliance_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::AGX_TwistRangeController_FL_eventSetCompliance_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetCompliance)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Compliance);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetCompliance(Z_Param_Out_Constraint,Z_Param_Compliance);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetCompliance ************************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetEnable **************************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics
{
	struct AGX_TwistRangeController_FL_eventSetEnable_Parms
	{
		FAGX_TwistRangeController Constraint;
		bool Enable;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Enable or disable an Elementary Constraint.\n\x09 * @param Constraint The Elementary Constraint to enable or disable.\n\x09 * @param Enable True to enable the Elementary Constraint, false to disable it.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Enable or disable an Elementary Constraint.\n@param Constraint The Elementary Constraint to enable or disable.\n@param Enable True to enable the Elementary Constraint, false to disable it." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetEnable constinit property declarations *****************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static void NewProp_Enable_SetBit(void* Obj);
	static const UECodeGen_Private::FBoolPropertyParams NewProp_Enable;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetEnable constinit property declarations *******************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetEnable Property Definitions ****************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetEnable_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
void Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Enable_SetBit(void* Obj)
{
	((AGX_TwistRangeController_FL_eventSetEnable_Parms*)Obj)->Enable = 1;
}
const UECodeGen_Private::FBoolPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Enable = { "Enable", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Bool | UECodeGen_Private::EPropertyGenFlags::NativeBool, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, sizeof(bool), sizeof(AGX_TwistRangeController_FL_eventSetEnable_Parms), &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Enable_SetBit, METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::NewProp_Enable,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::PropPointers) < 2048);
// ********** End Function SetEnable Property Definitions ******************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetEnable", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::AGX_TwistRangeController_FL_eventSetEnable_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::AGX_TwistRangeController_FL_eventSetEnable_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetEnable)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_UBOOL(Z_Param_Enable);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetEnable(Z_Param_Out_Constraint,Z_Param_Enable);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetEnable ****************************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetForceRange **********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics
{
	struct AGX_TwistRangeController_FL_eventSetForceRange_Parms
	{
		FAGX_TwistRangeController Constraint;
		double Min;
		double Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Set the Force Range of an Elementary Constraint. The force applied by the solver will always\n\x09 * be within this bound [N] or [Nm].\n\x09 * @param Constraint Constraint to set Force Range on.\n\x09 * @param Min Minimum force or torque the Elementary Constraint may apply [N] or [Nm].\n\x09 * @param Max Maximum force or torque the Elementary Constraint may apply [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the Force Range of an Elementary Constraint. The force applied by the solver will always\nbe within this bound [N] or [Nm].\n@param Constraint Constraint to set Force Range on.\n@param Min Minimum force or torque the Elementary Constraint may apply [N] or [Nm].\n@param Max Maximum force or torque the Elementary Constraint may apply [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetForceRange constinit property declarations *************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Min;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetForceRange constinit property declarations ***************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetForceRange Property Definitions ************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRange_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::PropPointers) < 2048);
// ********** End Function SetForceRange Property Definitions **************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetForceRange", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::AGX_TwistRangeController_FL_eventSetForceRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::AGX_TwistRangeController_FL_eventSetForceRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetForceRange)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Min);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetForceRange(Z_Param_Out_Constraint,Z_Param_Min,Z_Param_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetForceRange ************************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetForceRangeMax *******************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics
{
	struct AGX_TwistRangeController_FL_eventSetForceRangeMax_Parms
	{
		FAGX_TwistRangeController Constraint;
		double Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Set the maximum force or torque an Elementary Constraint can apply [N] or [Nm].\n\x09 * @param Constraint The Elementary Constraint to set maximum force range on.\n\x09 * @param Max The new maximum force or torque [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the maximum force or torque an Elementary Constraint can apply [N] or [Nm].\n@param Constraint The Elementary Constraint to set maximum force range on.\n@param Max The new maximum force or torque [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetForceRangeMax constinit property declarations **********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetForceRangeMax constinit property declarations ************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetForceRangeMax Property Definitions *********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRangeMax_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRangeMax_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::PropPointers) < 2048);
// ********** End Function SetForceRangeMax Property Definitions ***********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetForceRangeMax", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::AGX_TwistRangeController_FL_eventSetForceRangeMax_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::AGX_TwistRangeController_FL_eventSetForceRangeMax_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetForceRangeMax)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetForceRangeMax(Z_Param_Out_Constraint,Z_Param_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetForceRangeMax *********************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetForceRangeMin *******************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics
{
	struct AGX_TwistRangeController_FL_eventSetForceRangeMin_Parms
	{
		FAGX_TwistRangeController Constraint;
		double Min;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Set the minimum force or torque an Elementary Constraint can apply [N] or [Nm].\n\x09 * @param Constraint The Elementary Constraint to set minimum force range on.\n\x09 * @param Min The new minimum force or torque [N] or [Nm].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the minimum force or torque an Elementary Constraint can apply [N] or [Nm].\n@param Constraint The Elementary Constraint to set minimum force range on.\n@param Min The new minimum force or torque [N] or [Nm]." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetForceRangeMin constinit property declarations **********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Min;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetForceRangeMin constinit property declarations ************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetForceRangeMin Property Definitions *********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRangeMin_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetForceRangeMin_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::NewProp_Min,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::PropPointers) < 2048);
// ********** End Function SetForceRangeMin Property Definitions ***********************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetForceRangeMin", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::AGX_TwistRangeController_FL_eventSetForceRangeMin_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::AGX_TwistRangeController_FL_eventSetForceRangeMin_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetForceRangeMin)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Min);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetForceRangeMin(Z_Param_Out_Constraint,Z_Param_Min);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetForceRangeMin *********************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetRange ***************************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics
{
	struct AGX_TwistRangeController_FL_eventSetRange_Parms
	{
		FAGX_TwistRangeController Controller;
		double Min;
		double Max;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Twist Range Controller" },
		{ "Comment", "/**\n\x09 * Set the range that the two constrained bodies may twist relative to each other [deg].\n\x09 * @param Controller The Twist Range Controller to set range on.\n\x09 * @param Min The minimum allowed angle [deg].\n\x09 * @param Max The maximum allowed angle [deg].\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the range that the two constrained bodies may twist relative to each other [deg].\n@param Controller The Twist Range Controller to set range on.\n@param Min The minimum allowed angle [deg].\n@param Max The maximum allowed angle [deg]." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetRange constinit property declarations ******************************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Controller;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Min;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_Max;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetRange constinit property declarations ********************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetRange Property Definitions *****************************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Controller = { "Controller", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetRange_Parms, Controller), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Min = { "Min", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetRange_Parms, Min), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Max = { "Max", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetRange_Parms, Max), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Controller,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Min,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::NewProp_Max,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::PropPointers) < 2048);
// ********** End Function SetRange Property Definitions *******************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetRange", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::AGX_TwistRangeController_FL_eventSetRange_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::AGX_TwistRangeController_FL_eventSetRange_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetRange)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Controller);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Min);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_Max);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetRange(Z_Param_Out_Controller,Z_Param_Min,Z_Param_Max);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetRange *****************************

// ********** Begin Class UAGX_TwistRangeController_FL Function SetSpookDamping ********************
struct Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics
{
	struct AGX_TwistRangeController_FL_eventSetSpookDamping_Parms
	{
		FAGX_TwistRangeController Constraint;
		double SpookDamping;
	};
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Function_MetaDataParams[] = {
		{ "Category", "AGX Elementary Constraint" },
		{ "Comment", "/**\n\x09 * Set the Spook damping time of an Elementary Constraint [s].\n\x09 * @param Constraint Elementary Constraint to set Spook Damping on.\n\x09 * @param SpookDamping New Spook damping time.\n\x09 */" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "Set the Spook damping time of an Elementary Constraint [s].\n@param Constraint Elementary Constraint to set Spook Damping on.\n@param SpookDamping New Spook damping time." },
	};
#endif // WITH_METADATA

// ********** Begin Function SetSpookDamping constinit property declarations ***********************
	static const UECodeGen_Private::FStructPropertyParams NewProp_Constraint;
	static const UECodeGen_Private::FDoublePropertyParams NewProp_SpookDamping;
	static const UECodeGen_Private::FPropertyParamsBase* const PropPointers[];
// ********** End Function SetSpookDamping constinit property declarations *************************
	static const UECodeGen_Private::FFunctionParams FuncParams;
};

// ********** Begin Function SetSpookDamping Property Definitions **********************************
const UECodeGen_Private::FStructPropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::NewProp_Constraint = { "Constraint", nullptr, (EPropertyFlags)0x0010000008000180, UECodeGen_Private::EPropertyGenFlags::Struct, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetSpookDamping_Parms, Constraint), Z_Construct_UScriptStruct_FAGX_TwistRangeController, METADATA_PARAMS(0, nullptr) }; // 1183552290
const UECodeGen_Private::FDoublePropertyParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::NewProp_SpookDamping = { "SpookDamping", nullptr, (EPropertyFlags)0x0010000000000080, UECodeGen_Private::EPropertyGenFlags::Double, RF_Public|RF_Transient|RF_MarkAsNative, nullptr, nullptr, 1, STRUCT_OFFSET(AGX_TwistRangeController_FL_eventSetSpookDamping_Parms, SpookDamping), METADATA_PARAMS(0, nullptr) };
const UECodeGen_Private::FPropertyParamsBase* const Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::PropPointers[] = {
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::NewProp_Constraint,
	(const UECodeGen_Private::FPropertyParamsBase*)&Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::NewProp_SpookDamping,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::PropPointers) < 2048);
// ********** End Function SetSpookDamping Property Definitions ************************************
const UECodeGen_Private::FFunctionParams Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::FuncParams = { { (UObject*(*)())Z_Construct_UClass_UAGX_TwistRangeController_FL, nullptr, "SetSpookDamping", 	Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::PropPointers, 
	UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::PropPointers), 
sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::AGX_TwistRangeController_FL_eventSetSpookDamping_Parms),
RF_Public|RF_Transient|RF_MarkAsNative, (EFunctionFlags)0x04442401, 0, 0, METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::Function_MetaDataParams), Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::Function_MetaDataParams)},  };
static_assert(sizeof(Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::AGX_TwistRangeController_FL_eventSetSpookDamping_Parms) < MAX_uint16);
UFunction* Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping()
{
	static UFunction* ReturnFunction = nullptr;
	if (!ReturnFunction)
	{
		UECodeGen_Private::ConstructUFunction(&ReturnFunction, Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping_Statics::FuncParams);
	}
	return ReturnFunction;
}
DEFINE_FUNCTION(UAGX_TwistRangeController_FL::execSetSpookDamping)
{
	P_GET_STRUCT_REF(FAGX_TwistRangeController,Z_Param_Out_Constraint);
	P_GET_PROPERTY(FDoubleProperty,Z_Param_SpookDamping);
	P_FINISH;
	P_NATIVE_BEGIN;
	UAGX_TwistRangeController_FL::SetSpookDamping(Z_Param_Out_Constraint,Z_Param_SpookDamping);
	P_NATIVE_END;
}
// ********** End Class UAGX_TwistRangeController_FL Function SetSpookDamping **********************

// ********** Begin Class UAGX_TwistRangeController_FL *********************************************
FClassRegistrationInfo Z_Registration_Info_UClass_UAGX_TwistRangeController_FL;
UClass* UAGX_TwistRangeController_FL::GetPrivateStaticClass()
{
	using TClass = UAGX_TwistRangeController_FL;
	if (!Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.InnerSingleton)
	{
		GetPrivateStaticClassBody(
			TClass::StaticPackage(),
			TEXT("AGX_TwistRangeController_FL"),
			Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.InnerSingleton,
			StaticRegisterNativesUAGX_TwistRangeController_FL,
			sizeof(TClass),
			alignof(TClass),
			TClass::StaticClassFlags,
			TClass::StaticClassCastFlags(),
			TClass::StaticConfigName(),
			(UClass::ClassConstructorType)InternalConstructor<TClass>,
			(UClass::ClassVTableHelperCtorCallerType)InternalVTableHelperCtorCaller<TClass>,
			UOBJECT_CPPCLASS_STATICFUNCTIONS_FORCLASS(TClass),
			&TClass::Super::StaticClass,
			&TClass::WithinClass::StaticClass
		);
	}
	return Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.InnerSingleton;
}
UClass* Z_Construct_UClass_UAGX_TwistRangeController_FL_NoRegister()
{
	return UAGX_TwistRangeController_FL::GetPrivateStaticClass();
}
struct Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics
{
#if WITH_METADATA
	static constexpr UECodeGen_Private::FMetaDataPairParam Class_MetaDataParams[] = {
		{ "Comment", "/**\n * This class acts as an API that exposes functions of FAGX_TwistRangeController in Blueprints.\n */" },
		{ "IncludePath", "Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ModuleRelativePath", "Public/Constraints/Controllers/AGX_TwistRangeController.h" },
		{ "ToolTip", "This class acts as an API that exposes functions of FAGX_TwistRangeController in Blueprints." },
	};
#endif // WITH_METADATA

// ********** Begin Class UAGX_TwistRangeController_FL constinit property declarations *************
// ********** End Class UAGX_TwistRangeController_FL constinit property declarations ***************
	static constexpr UE::CodeGen::FClassNativeFunction Funcs[] = {
		{ .NameUTF8 = UTF8TEXT("GetCompliance"), .Pointer = &UAGX_TwistRangeController_FL::execGetCompliance },
		{ .NameUTF8 = UTF8TEXT("GetEnable"), .Pointer = &UAGX_TwistRangeController_FL::execGetEnable },
		{ .NameUTF8 = UTF8TEXT("GetForceRange"), .Pointer = &UAGX_TwistRangeController_FL::execGetForceRange },
		{ .NameUTF8 = UTF8TEXT("GetForceRangeMax"), .Pointer = &UAGX_TwistRangeController_FL::execGetForceRangeMax },
		{ .NameUTF8 = UTF8TEXT("GetForceRangeMin"), .Pointer = &UAGX_TwistRangeController_FL::execGetForceRangeMin },
		{ .NameUTF8 = UTF8TEXT("GetRange"), .Pointer = &UAGX_TwistRangeController_FL::execGetRange },
		{ .NameUTF8 = UTF8TEXT("GetSpookDamping"), .Pointer = &UAGX_TwistRangeController_FL::execGetSpookDamping },
		{ .NameUTF8 = UTF8TEXT("SetCompliance"), .Pointer = &UAGX_TwistRangeController_FL::execSetCompliance },
		{ .NameUTF8 = UTF8TEXT("SetEnable"), .Pointer = &UAGX_TwistRangeController_FL::execSetEnable },
		{ .NameUTF8 = UTF8TEXT("SetForceRange"), .Pointer = &UAGX_TwistRangeController_FL::execSetForceRange },
		{ .NameUTF8 = UTF8TEXT("SetForceRangeMax"), .Pointer = &UAGX_TwistRangeController_FL::execSetForceRangeMax },
		{ .NameUTF8 = UTF8TEXT("SetForceRangeMin"), .Pointer = &UAGX_TwistRangeController_FL::execSetForceRangeMin },
		{ .NameUTF8 = UTF8TEXT("SetRange"), .Pointer = &UAGX_TwistRangeController_FL::execSetRange },
		{ .NameUTF8 = UTF8TEXT("SetSpookDamping"), .Pointer = &UAGX_TwistRangeController_FL::execSetSpookDamping },
	};
	static UObject* (*const DependentSingletons[])();
	static constexpr FClassFunctionLinkInfo FuncInfo[] = {
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetCompliance, "GetCompliance" }, // 3307092933
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetEnable, "GetEnable" }, // 937456486
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRange, "GetForceRange" }, // 4253842978
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMax, "GetForceRangeMax" }, // 253142536
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetForceRangeMin, "GetForceRangeMin" }, // 1122229976
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetRange, "GetRange" }, // 2302130980
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_GetSpookDamping, "GetSpookDamping" }, // 1881497848
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetCompliance, "SetCompliance" }, // 227105769
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetEnable, "SetEnable" }, // 2755278659
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRange, "SetForceRange" }, // 3840125284
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMax, "SetForceRangeMax" }, // 1855583479
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetForceRangeMin, "SetForceRangeMin" }, // 2242811409
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetRange, "SetRange" }, // 2530573991
		{ &Z_Construct_UFunction_UAGX_TwistRangeController_FL_SetSpookDamping, "SetSpookDamping" }, // 2531344981
	};
	static_assert(UE_ARRAY_COUNT(FuncInfo) < 2048);
	static constexpr FCppClassTypeInfoStatic StaticCppClassTypeInfo = {
		TCppClassTypeTraits<UAGX_TwistRangeController_FL>::IsAbstract,
	};
	static const UECodeGen_Private::FClassParams ClassParams;
}; // struct Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics
UObject* (*const Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::DependentSingletons[])() = {
	(UObject* (*)())Z_Construct_UClass_UBlueprintFunctionLibrary,
	(UObject* (*)())Z_Construct_UPackage__Script_AGXUnreal,
};
static_assert(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::DependentSingletons) < 16);
const UECodeGen_Private::FClassParams Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::ClassParams = {
	&UAGX_TwistRangeController_FL::StaticClass,
	nullptr,
	&StaticCppClassTypeInfo,
	DependentSingletons,
	FuncInfo,
	nullptr,
	nullptr,
	UE_ARRAY_COUNT(DependentSingletons),
	UE_ARRAY_COUNT(FuncInfo),
	0,
	0,
	0x001000A0u,
	METADATA_PARAMS(UE_ARRAY_COUNT(Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::Class_MetaDataParams), Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::Class_MetaDataParams)
};
void UAGX_TwistRangeController_FL::StaticRegisterNativesUAGX_TwistRangeController_FL()
{
	UClass* Class = UAGX_TwistRangeController_FL::StaticClass();
	FNativeFunctionRegistrar::RegisterFunctions(Class, MakeConstArrayView(Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::Funcs));
}
UClass* Z_Construct_UClass_UAGX_TwistRangeController_FL()
{
	if (!Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.OuterSingleton)
	{
		UECodeGen_Private::ConstructUClass(Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.OuterSingleton, Z_Construct_UClass_UAGX_TwistRangeController_FL_Statics::ClassParams);
	}
	return Z_Registration_Info_UClass_UAGX_TwistRangeController_FL.OuterSingleton;
}
UAGX_TwistRangeController_FL::UAGX_TwistRangeController_FL(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer) {}
DEFINE_VTABLE_PTR_HELPER_CTOR_NS(, UAGX_TwistRangeController_FL);
UAGX_TwistRangeController_FL::~UAGX_TwistRangeController_FL() {}
// ********** End Class UAGX_TwistRangeController_FL ***********************************************

// ********** Begin Registration *******************************************************************
struct Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics
{
	static constexpr FStructRegisterCompiledInInfo ScriptStructInfo[] = {
		{ FAGX_TwistRangeController::StaticStruct, Z_Construct_UScriptStruct_FAGX_TwistRangeController_Statics::NewStructOps, TEXT("AGX_TwistRangeController"),&Z_Registration_Info_UScriptStruct_FAGX_TwistRangeController, CONSTRUCT_RELOAD_VERSION_INFO(FStructReloadVersionInfo, sizeof(FAGX_TwistRangeController), 1183552290U) },
	};
	static constexpr FClassRegisterCompiledInInfo ClassInfo[] = {
		{ Z_Construct_UClass_UAGX_TwistRangeController_FL, UAGX_TwistRangeController_FL::StaticClass, TEXT("UAGX_TwistRangeController_FL"), &Z_Registration_Info_UClass_UAGX_TwistRangeController_FL, CONSTRUCT_RELOAD_VERSION_INFO(FClassReloadVersionInfo, sizeof(UAGX_TwistRangeController_FL), 3707164532U) },
	};
}; // Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics 
static FRegisterCompiledInInfo Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_3242944196{
	TEXT("/Script/AGXUnreal"),
	Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics::ClassInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics::ClassInfo),
	Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics::ScriptStructInfo, UE_ARRAY_COUNT(Z_CompiledInDeferFile_FID_builds_algoryx_unreal_agxunreal_s_selfhosted_build_AGXUnreal_HostProject_Plugins_AGXUnreal_Source_AGXUnreal_Public_Constraints_Controllers_AGX_TwistRangeController_h__Script_AGXUnreal_Statics::ScriptStructInfo),
	nullptr, 0,
};
// ********** End Registration *********************************************************************

PRAGMA_ENABLE_DEPRECATION_WARNINGS
