%module(package="openplx") Vehicles
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Vehicles/Vehicles.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Vehicles(Vehicles_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Vehicles();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Vehicles();
OPENPLX_SWIG_BUNDLE_VECTORS_Vehicles();
%include "openplx/Vehicles/Vehicle.h"
%include "openplx/Vehicles/FourWheel/FrontWheelDrive.h"
%include "openplx/Vehicles/Steering/Interactions/DualSuspensionSteering.h"
%include "openplx/Vehicles/Steering/Interactions/Ackermann.h"
%include "openplx/Vehicles/Steering/Interactions/BellCrank.h"
%include "openplx/Vehicles/Steering/Interactions/RackAndPinion.h"
%include "openplx/Vehicles/Suspensions/Interactions/Connector.h"
%include "openplx/Vehicles/Suspensions/Interactions/Mate.h"
%include "openplx/Vehicles/Suspensions/Interactions/LinearSpringDamperMate.h"
%include "openplx/Vehicles/Suspensions/Suspension.h"
%include "openplx/Vehicles/Suspensions/SingleMateSuspension.h"
%include "openplx/Vehicles/Suspensions/LinearSpringDamper.h"
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%include "openplx/Vehicles/Wheels/Actuator.h"
%include "openplx/Vehicles/Wheels/Wheel.h"
%include "openplx/Vehicles/Wheels/ElasticWheel.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/DefaultWheelDissipation.h"
%include "openplx/Vehicles/Wheels/Interactions/Dissipation/WheelMechanicalDamping.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/DefaultWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/Interactions/Flexibility/LinearElasticWheelFlexibility.h"
%include "openplx/Vehicles/Wheels/RimTrait.h"
%include "openplx/Vehicles/Wheels/Rim.h"
%include "openplx/Vehicles/Wheels/TireTrait.h"
%include "openplx/Vehicles/Wheels/Tire.h"
