%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Math()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Math()
%{
#include <openplx/Math/Math_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Math(prefix)
%rename(prefix ## AffineTransform) openplx::Math::AffineTransform;
%rename(prefix ## Functions) openplx::Math::Functions;
%rename(prefix ## Line) openplx::Math::Line;
%rename(prefix ## Matrix3x3) openplx::Math::Matrix3x3;
%rename(prefix ## Matrix4x4) openplx::Math::Matrix4x4;
%rename(prefix ## Quat) openplx::Math::Quat;
%rename(prefix ## Vec2) openplx::Math::Vec2;
%rename(prefix ## Vec3) openplx::Math::Vec3;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Math()
%shared_ptr(openplx::Math::AffineTransform);
%shared_ptr(openplx::Math::Functions);
%shared_ptr(openplx::Math::Line);
%shared_ptr(openplx::Math::Matrix3x3);
%shared_ptr(openplx::Math::Matrix4x4);
%shared_ptr(openplx::Math::Quat);
%shared_ptr(openplx::Math::Vec2);
%shared_ptr(openplx::Math::Vec3);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Math()
%typemap(out) std::shared_ptr<openplx::Math::AffineTransform> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Functions> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Line> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Matrix3x3> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Matrix4x4> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Quat> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Vec2> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Math::Vec3> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Math()
%template(Math_AffineTransform_Vector) std::vector<std::shared_ptr<openplx::Math::AffineTransform>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::AffineTransform>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::AffineTransform>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::AffineTransform>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::AffineTransform>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::AffineTransform>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::AffineTransform>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Functions_Vector) std::vector<std::shared_ptr<openplx::Math::Functions>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Functions>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Functions>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Functions>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Functions>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Functions>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Functions>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Line_Vector) std::vector<std::shared_ptr<openplx::Math::Line>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Line>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Line>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Line>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Line>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Line>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Line>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Matrix3x3_Vector) std::vector<std::shared_ptr<openplx::Math::Matrix3x3>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Matrix3x3>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Matrix3x3>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Matrix3x3>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Matrix3x3>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Matrix3x3>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Matrix3x3>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Matrix4x4_Vector) std::vector<std::shared_ptr<openplx::Math::Matrix4x4>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Matrix4x4>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Matrix4x4>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Matrix4x4>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Matrix4x4>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Matrix4x4>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Matrix4x4>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Quat_Vector) std::vector<std::shared_ptr<openplx::Math::Quat>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Quat>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Quat>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Quat>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Quat>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Quat>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Quat>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Vec2_Vector) std::vector<std::shared_ptr<openplx::Math::Vec2>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Vec2>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Vec2>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Vec2>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Vec2>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Vec2>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Vec2>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Math_Vec3_Vector) std::vector<std::shared_ptr<openplx::Math::Vec3>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Vec3>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Vec3>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Vec3>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Vec3>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Vec3>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Vec3>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Math()
%include "openplx/Math/AffineTransform.h"
%include "openplx/Math/Functions.h"
%include "openplx/Math/Line.h"
%include "openplx/Math/Matrix3x3.h"
%include "openplx/Math/Matrix4x4.h"
%include "openplx/Math/Quat.h"
%include "openplx/Math/Vec2.h"
%include "openplx/Math/Vec3.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Math()
%pythoncode %{
from . import Random
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Math_Random()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Math_Random()
%{
#include <openplx/Math/Math_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Math_Random(prefix)
%rename(prefix ## GaussianDistribution) openplx::Math::Random::GaussianDistribution;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Math_Random()
%shared_ptr(openplx::Math::Random::GaussianDistribution);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Math_Random()
%typemap(out) std::shared_ptr<openplx::Math::Random::GaussianDistribution> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Math_Random()
%template(Math_Random_GaussianDistribution_Vector) std::vector<std::shared_ptr<openplx::Math::Random::GaussianDistribution>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Math::Random::GaussianDistribution>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Math::Random::GaussianDistribution>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Random::GaussianDistribution>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Math::Random::GaussianDistribution>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Math::Random::GaussianDistribution>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Math::Random::GaussianDistribution>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Math_Random()
%include "openplx/Math/Random/GaussianDistribution.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Math_Random()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Math()
%{
#include <openplx/Math/Math_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Math()
%import "Math.i"
%import "Math_Random.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Math()
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Math()
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Math(prefix)
OPENPLX_SWIG_NS_RENAMES_Math(prefix);
OPENPLX_SWIG_NS_RENAMES_Math_Random(prefix ## Random_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Math()
OPENPLX_SWIG_NS_SHARED_POINTERS_Math();
OPENPLX_SWIG_NS_SHARED_POINTERS_Math_Random();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Math()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Math();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Math_Random();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Math()
OPENPLX_SWIG_NS_VECTORS_Math();
OPENPLX_SWIG_NS_VECTORS_Math_Random();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Math()
OPENPLX_SWIG_NS_INCLUDES_Math();
OPENPLX_SWIG_NS_INCLUDES_Math_Random();
%enddef

