#ifndef __EXPORT_H__
#define __EXPORT_H__
#ifndef OPENPLX_CORE_EXPORT_H
#define OPENPLX_CORE_EXPORT_H

#if defined _WIN32 || defined __CYGWIN__
  #if defined(__OPENPLX_CORE_STATIC__)
    #define OPENPLX_CORE_EXPORT
  #elif defined(__OPENPLX_CORE_EXPORTING__)
    /* building DLL (export) */
    #ifdef __GNUC__
      #define OPENPLX_CORE_EXPORT __attribute__ ((dllexport))
    #else
      // CMake currently exports all symbols on Windows using the WINDOWS_EXPORT_ALL_SYMBOLS option
      // Specifying this again results in multiple export warnings
      #define OPENPLX_CORE_EXPORT __declspec(dllexport)
    #endif
  #else
    /* using DLL (import) */
    #ifdef __GNUC__
      #define OPENPLX_CORE_EXPORT __attribute__ ((dllimport))
    #else
      #define OPENPLX_CORE_EXPORT __declspec(dllimport)
    #endif
  #endif

#else
  #if __GNUC__ >= 4
    #define OPENPLX_CORE_EXPORT __attribute__ ((visibility ("default")))
  #else
    #define OPENPLX_CORE_EXPORT
  #endif
#endif

#endif /* OPENPLX_CORE_EXPORT_H */

#endif // __EXPORT_H__
