#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Physics3D/Interactions/RedirectedMateConnector.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RoadWheel */
namespace openplx::Vehicles::Tracks {
    /**
     * The most basic road wheel definition intended for extension, not for direct usage.
     * Assumed to have its origin at the Tracks.System origin,
     * thereby center_connector can be placed relative the Tracks.System.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT RoadWheel : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_local_center_axis;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> m_center_connector;

        public:
            RoadWheel();
            virtual ~RoadWheel();
            std::shared_ptr<openplx::Math::Vec3> local_center_axis() const;
            std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> center_connector() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
