#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/CylindricalRoller.h>
#include <openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RigidCylindricalRoller */
namespace openplx::Vehicles::Tracks {
    /**
     * A CylindricalRoller with a rigid body and a
     * cylinder as contact_geometry.
     * local_center_axis is y direction by default assuming that the non rotated cylinder axis is in y direction.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT RigidCylindricalRoller : public openplx::Vehicles::Tracks::CylindricalRoller {
        protected:

        public:
            RigidCylindricalRoller();
            virtual ~RigidCylindricalRoller();
            std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody> body() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
