#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Interaction.h>
#include <openplx/Vehicles/Suspensions/SingleMateSuspension.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model DualSuspensionSteering */
namespace openplx::Vehicles::Steering::Interactions {
    /**
     * Base class for various steering mechanisms, given two SingleMateSuspensions,
     * both having the compatible steering trait.
     **/
    class OPENPLX_Vehicles_BUNDLE_EXPORT DualSuspensionSteering : public openplx::Physics::Interactions::Interaction {
        protected:
            double m_knuckle_angle;
            double m_knuckle_length;
            std::weak_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension> m_left_suspension;
            std::weak_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension> m_right_suspension;

        public:
            DualSuspensionSteering();
            virtual ~DualSuspensionSteering();
            double knuckle_angle() const;
            double knuckle_length() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension> left_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::SingleMateSuspension> right_suspension() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
