#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Vehicle.h>
#include <openplx/Vehicles/Wheels/Wheel.h>
#include <openplx/Vehicles/Suspensions/Suspension.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model FrontWheelDrive */
namespace openplx::Vehicles::FourWheel {
    /**
     *     This Vehicle is abstract.
     *     The Wheels have the most basic type
     *     The suspension could be any System or the Suspension interaction
     *     */
    class OPENPLX_Vehicles_BUNDLE_EXPORT FrontWheelDrive : public openplx::Vehicles::Vehicle {
        protected:
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> m_front_left_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> m_front_right_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> m_rear_left_wheel;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> m_rear_right_wheel;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> m_front_left_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> m_front_right_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> m_rear_left_suspension;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> m_rear_right_suspension;

        public:
            FrontWheelDrive();
            virtual ~FrontWheelDrive();
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> front_left_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> front_right_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> rear_left_wheel() const;
            std::shared_ptr<openplx::Vehicles::Wheels::Wheel> rear_right_wheel() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> front_left_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> front_right_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> rear_left_suspension() const;
            std::shared_ptr<openplx::Vehicles::Suspensions::Suspension> rear_right_suspension() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
